/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.ReadBuffer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B&\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrTableReader;", "K", "", "buffer", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "keyReader", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/library/impl/ReadBuffer;Lkotlin/jvm/functions/Function1;)V", "indexToOffset", "", "Lkotlin/Pair;", "", "tableItemBytes", "", "id", "(Ljava/lang/Object;)[B", "kotlin-util-klib"})
public abstract class IrTableReader<K> {
    @NotNull
    private final ReadBuffer buffer;
    @NotNull
    private final Map<K, Pair<Integer, Integer>> indexToOffset;

    public IrTableReader(@NotNull ReadBuffer buffer, @NotNull Function1<? super ReadBuffer, ? extends K> keyReader) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(keyReader, "keyReader");
        this.buffer = buffer;
        this.indexToOffset = new LinkedHashMap();
        int count2 = this.buffer.getInt();
        for (int i2 = 0; i2 < count2; ++i2) {
            K key = keyReader.invoke(this.buffer);
            int offset2 = this.buffer.getInt();
            int size = this.buffer.getInt();
            this.indexToOffset.put(key, TuplesKt.to(offset2, size));
        }
    }

    @NotNull
    public final byte[] tableItemBytes(K id) {
        Pair<Integer, Integer> pair = this.indexToOffset.get(id);
        if (pair == null) {
            throw new IllegalStateException(("No coordinates found for " + id).toString());
        }
        Pair<Integer, Integer> coordinates = pair;
        int offset2 = ((Number)coordinates.getFirst()).intValue();
        int size = ((Number)coordinates.getSecond()).intValue();
        byte[] result2 = new byte[size];
        this.buffer.setPosition(offset2);
        this.buffer.get(result2, 0, size);
        return result2;
    }
}

