/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.DocType;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.IllegalAddException;
import org.jetbrains.kotlin.org.jdom.Parent;

final class ContentList
extends AbstractList<Content>
implements RandomAccess {
    private Content[] elementData = null;
    private int size;
    private transient int sizeModCount = Integer.MIN_VALUE;
    private transient int dataModiCount = Integer.MIN_VALUE;
    private final Parent parent;

    ContentList(Parent parent2) {
        this.parent = parent2;
    }

    private void setModCount(int sizemod, int datamod) {
        this.sizeModCount = sizemod;
        this.dataModiCount = datamod;
    }

    private int getModCount() {
        return this.sizeModCount;
    }

    private void incModCount() {
        ++this.dataModiCount;
        ++this.sizeModCount;
    }

    private void incDataModOnly() {
        ++this.dataModiCount;
    }

    private int getDataModCount() {
        return this.dataModiCount;
    }

    private void checkIndex(int index, boolean excludes) {
        int max;
        int n = max = excludes ? this.size - 1 : this.size;
        if (index < 0 || index > max) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + this.size);
        }
    }

    private void checkPreConditions(Content child, int index, boolean replace) {
        if (child == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this.checkIndex(index, replace);
        if (child.getParent() != null) {
            Parent p2 = child.getParent();
            if (p2 instanceof Document) {
                throw new IllegalAddException((Element)child, "The Content already has an existing parent document");
            }
            throw new IllegalAddException("The Content already has an existing parent \"" + ((Element)p2).getQualifiedName() + "\"");
        }
        if (child == this.parent) {
            throw new IllegalAddException("The Element cannot be added to itself");
        }
        if (this.parent instanceof Element && child instanceof Element && ((Element)child).isAncestor((Element)this.parent)) {
            throw new IllegalAddException("The Element cannot be added as a descendent of itself");
        }
    }

    @Override
    public void add(int index, Content child) {
        this.checkPreConditions(child, index, false);
        this.parent.canContainContent(child, index, false);
        child.setParent(this.parent);
        this.ensureCapacity(this.size + 1);
        if (index == this.size) {
            this.elementData[this.size++] = child;
        } else {
            System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
            this.elementData[index] = child;
            ++this.size;
        }
        this.incModCount();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Content> collection) {
        if (collection == null) {
            ContentList.$$$reportNull$$$0(0);
        }
        return this.addAll(this.size, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends Content> collection) {
        if (collection == null) {
            throw new NullPointerException("Can not add a null collection to the ContentList");
        }
        this.checkIndex(index, false);
        if (collection.isEmpty()) {
            return false;
        }
        int addcnt = collection.size();
        if (addcnt == 1) {
            this.add(index, collection.iterator().next());
            return true;
        }
        this.ensureCapacity(this.size() + addcnt);
        int tmpmodcount = this.getModCount();
        int tmpdmc = this.getDataModCount();
        boolean ok = false;
        int count2 = 0;
        try {
            for (Content content : collection) {
                this.add(index + count2, content);
                ++count2;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                while (--count2 >= 0) {
                    this.remove(index + count2);
                }
                this.setModCount(tmpmodcount, tmpdmc);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.elementData != null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                Content obj = this.elementData[i2];
                ContentList.removeParent(obj);
            }
            this.elementData = null;
            this.size = 0;
        }
        this.incModCount();
    }

    void ensureCapacity(int minCapacity) {
        if (this.elementData == null) {
            this.elementData = new Content[Math.max(minCapacity, 4)];
            return;
        }
        if (minCapacity < this.elementData.length) {
            return;
        }
        int newcap = this.size * 3 / 2 + 1;
        int len = Math.max(newcap, minCapacity);
        this.elementData = Arrays.copyOf(this.elementData, len);
    }

    @Override
    public Content get(int index) {
        this.checkIndex(index, true);
        return this.elementData[index];
    }

    int indexOfFirstElement() {
        if (this.elementData != null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!(this.elementData[i2] instanceof Element)) continue;
                return i2;
            }
        }
        return -1;
    }

    int indexOfDocType() {
        if (this.elementData != null) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (!(this.elementData[i2] instanceof DocType)) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public Content remove(int index) {
        this.checkIndex(index, true);
        Content old = this.elementData[index];
        ContentList.removeParent(old);
        System.arraycopy(this.elementData, index + 1, this.elementData, index, this.size - index - 1);
        this.elementData[--this.size] = null;
        this.incModCount();
        return old;
    }

    private static void removeParent(Content c) {
        c.setParent(null);
    }

    @Override
    public Content set(int index, Content child) {
        this.checkPreConditions(child, index, true);
        this.parent.canContainContent(child, index, true);
        Content old = this.elementData[index];
        ContentList.removeParent(old);
        child.setParent(this.parent);
        this.elementData[index] = child;
        this.incDataModOnly();
        return old;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<Content> iterator() {
        return new CLIterator();
    }

    @Override
    @NotNull
    public ListIterator<Content> listIterator() {
        return new CLListIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<Content> listIterator(int start) {
        return new CLListIterator(start);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    private void sortInPlace(int[] indexes) {
        int i2;
        int[] unsorted = (int[])indexes.clone();
        Arrays.sort(unsorted);
        Content[] usc = new Content[unsorted.length];
        for (i2 = 0; i2 < usc.length; ++i2) {
            usc[i2] = this.elementData[indexes[i2]];
        }
        for (i2 = 0; i2 < indexes.length; ++i2) {
            this.elementData[unsorted[i2]] = usc[i2];
        }
    }

    private int binarySearch(int[] indexes, int len, int val, Comparator<? super Content> comp) {
        int left = 0;
        int right = len - 1;
        Content base2 = this.elementData[val];
        while (left <= right) {
            int mid = left + right >>> 1;
            int cmp = comp.compare(base2, this.elementData[indexes[mid]]);
            if (cmp == 0) {
                while (mid < right && comp.compare(base2, this.elementData[indexes[mid + 1]]) == 0) {
                    ++mid;
                }
                return mid + 1;
            }
            if (cmp < 0) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return left;
    }

    @Override
    public void sort(Comparator<? super Content> comp) {
        if (comp == null) {
            return;
        }
        int sz = this.size;
        int[] indexes = new int[sz];
        int i2 = 0;
        while (i2 < sz) {
            int ip = this.binarySearch(indexes, i2, i2, comp);
            if (ip < i2) {
                System.arraycopy(indexes, ip, indexes, ip + 1, i2 - ip);
            }
            indexes[ip] = i2++;
        }
        this.sortInPlace(indexes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "org/jetbrains/kotlin/org/jdom/ContentList", "addAll"));
    }

    private final class CLIterator
    implements Iterator<Content> {
        private int expect;
        private int cursor = 0;
        private boolean canremove = false;

        private CLIterator() {
            this.expect = ContentList.this.getModCount();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ContentList.this.size;
        }

        @Override
        public Content next() {
            if (ContentList.this.getModCount() != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (this.cursor >= ContentList.this.size) {
                throw new NoSuchElementException("Iterated beyond the end of the ContentList.");
            }
            this.canremove = true;
            return ContentList.this.elementData[this.cursor++];
        }

        @Override
        public void remove() {
            if (ContentList.this.getModCount() != this.expect) {
                throw new ConcurrentModificationException("ContentList was modified outside of this Iterator");
            }
            if (!this.canremove) {
                throw new IllegalStateException("Can only remove() content after a call to next()");
            }
            this.canremove = false;
            ContentList.this.remove(--this.cursor);
            this.expect = ContentList.this.getModCount();
        }
    }

    private final class CLListIterator
    implements ListIterator<Content> {
        private boolean forward;
        private boolean canremove = false;
        private boolean canset = false;
        private int expectedmod;
        private int cursor;

        private CLListIterator(int start) {
            this.expectedmod = ContentList.this.getModCount();
            this.forward = false;
            ContentList.this.checkIndex(start, false);
            this.cursor = start;
        }

        private void checkConcurrent() {
            if (this.expectedmod != ContentList.this.getModCount()) {
                throw new ConcurrentModificationException("The ContentList supporting this iterator has been modified bysomething other than this Iterator.");
            }
        }

        @Override
        public boolean hasNext() {
            return (this.forward ? this.cursor + 1 : this.cursor) < ContentList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return (this.forward ? this.cursor : this.cursor - 1) >= 0;
        }

        @Override
        public int nextIndex() {
            return this.forward ? this.cursor + 1 : this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.forward ? this.cursor : this.cursor - 1;
        }

        @Override
        public Content next() {
            int next;
            this.checkConcurrent();
            int n = next = this.forward ? this.cursor + 1 : this.cursor;
            if (next >= ContentList.this.size) {
                throw new NoSuchElementException("next() is beyond the end of the Iterator");
            }
            this.cursor = next;
            this.forward = true;
            this.canremove = true;
            this.canset = true;
            return ContentList.this.elementData[this.cursor];
        }

        @Override
        public Content previous() {
            int prev;
            this.checkConcurrent();
            int n = prev = this.forward ? this.cursor : this.cursor - 1;
            if (prev < 0) {
                throw new NoSuchElementException("previous() is beyond the beginning of the Iterator");
            }
            this.cursor = prev;
            this.forward = false;
            this.canremove = true;
            this.canset = true;
            return ContentList.this.elementData[this.cursor];
        }

        @Override
        public void add(Content obj) {
            this.checkConcurrent();
            int next = this.forward ? this.cursor + 1 : this.cursor;
            ContentList.this.add(next, obj);
            this.expectedmod = ContentList.this.getModCount();
            this.canset = false;
            this.canremove = false;
            this.cursor = next;
            this.forward = true;
        }

        @Override
        public void remove() {
            this.checkConcurrent();
            if (!this.canremove) {
                throw new IllegalStateException("Can not remove an element unless either next() or previous() has been called since the last remove()");
            }
            ContentList.this.remove(this.cursor);
            this.forward = false;
            this.expectedmod = ContentList.this.getModCount();
            this.canremove = false;
            this.canset = false;
        }

        @Override
        public void set(Content obj) {
            this.checkConcurrent();
            if (!this.canset) {
                throw new IllegalStateException("Can not set an element unless either next() or previous() has been called since the last remove() or set()");
            }
            ContentList.this.set(this.cursor, obj);
            this.expectedmod = ContentList.this.getModCount();
        }
    }
}

