/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingInputStream;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingInputStreamImpl;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingReader;
import org.jetbrains.kotlin.org.jline.utils.Timeout;

public class NonBlocking {
    public static NonBlockingInputStream nonBlocking(String name2, InputStream inputStream) {
        if (inputStream instanceof NonBlockingInputStream) {
            return (NonBlockingInputStream)inputStream;
        }
        return new NonBlockingInputStreamImpl(name2, inputStream);
    }

    public static NonBlockingReader nonBlocking(String name2, InputStream inputStream, Charset encoding) {
        return new NonBlockingInputStreamReader(NonBlocking.nonBlocking(name2, inputStream), encoding);
    }

    private static class NonBlockingInputStreamReader
    extends NonBlockingReader {
        private final NonBlockingInputStream input;
        private final CharsetDecoder decoder;
        private final ByteBuffer bytes;
        private final CharBuffer chars;

        public NonBlockingInputStreamReader(NonBlockingInputStream inputStream, Charset encoding) {
            this(inputStream, (encoding != null ? encoding : Charset.defaultCharset()).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        public NonBlockingInputStreamReader(NonBlockingInputStream input2, CharsetDecoder decoder) {
            this.input = input2;
            this.decoder = decoder;
            this.bytes = ByteBuffer.allocate(2048);
            this.chars = CharBuffer.allocate(1024);
            this.bytes.limit(0);
            this.chars.limit(0);
        }

        @Override
        protected int read(long timeout, boolean isPeek) throws IOException {
            Timeout t = new Timeout(timeout);
            while (!this.chars.hasRemaining() && !t.elapsed()) {
                int b2 = this.input.read(t.timeout());
                if (b2 == -1) {
                    return -1;
                }
                if (b2 < 0) continue;
                if (!this.bytes.hasRemaining()) {
                    this.bytes.position(0);
                    this.bytes.limit(0);
                }
                int l = this.bytes.limit();
                this.bytes.array()[this.bytes.arrayOffset() + l] = (byte)b2;
                this.bytes.limit(l + 1);
                this.chars.clear();
                this.decoder.decode(this.bytes, this.chars, false);
                this.chars.flip();
            }
            if (this.chars.hasRemaining()) {
                if (isPeek) {
                    return this.chars.get(this.chars.position());
                }
                return this.chars.get();
            }
            return -2;
        }

        @Override
        public int readBuffered(char[] b2, int off, int len, long timeout) throws IOException {
            int nb;
            if (b2 == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len < b2.length) {
                throw new IllegalArgumentException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.chars.hasRemaining()) {
                int r = Math.min(len, this.chars.remaining());
                this.chars.get(b2, off, r);
                return r;
            }
            Timeout t = new Timeout(timeout);
            while (!this.chars.hasRemaining() && !t.elapsed()) {
                if (!this.bytes.hasRemaining()) {
                    this.bytes.position(0);
                    this.bytes.limit(0);
                }
                if ((nb = this.input.readBuffered(this.bytes.array(), this.bytes.limit(), this.bytes.capacity() - this.bytes.limit(), t.timeout())) < 0) {
                    return nb;
                }
                this.bytes.limit(this.bytes.limit() + nb);
                this.chars.clear();
                this.decoder.decode(this.bytes, this.chars, false);
                this.chars.flip();
            }
            nb = Math.min(len, this.chars.remaining());
            this.chars.get(b2, off, nb);
            return nb;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

