/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000bH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0005H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils;", "", "<init>", "()V", "computeMaskFromModifierList", "", "modifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "computeMask", "hasModifier", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "", "maskHasModifier", "mask", "modifierToken", "maskToString", "", "psi"})
@SourceDebugExtension(value={"SMAP\nModifierMaskUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifierMaskUtils.kt\norg/jetbrains/kotlin/psi/stubs/impl/ModifierMaskUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class ModifierMaskUtils {
    @NotNull
    public static final ModifierMaskUtils INSTANCE;

    private ModifierMaskUtils() {
    }

    @JvmStatic
    public static final long computeMaskFromModifierList(@NotNull KtModifierList modifierList2) {
        Intrinsics.checkNotNullParameter(modifierList2, "modifierList");
        return ModifierMaskUtils.computeMask(arg_0 -> ModifierMaskUtils.computeMaskFromModifierList$lambda$1(modifierList2, arg_0));
    }

    @JvmStatic
    public static final long computeMask(@NotNull Function1<? super KtModifierKeywordToken, Boolean> hasModifier) {
        Intrinsics.checkNotNullParameter(hasModifier, "hasModifier");
        long mask = 0L;
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = KtTokens.MODIFIER_KEYWORDS_ARRAY;
        int n = ktModifierKeywordTokenArray.length;
        for (int j = 0; j < n; ++j) {
            int index = j;
            KtModifierKeywordToken modifierKeywordToken = ktModifierKeywordTokenArray[j];
            Intrinsics.checkNotNull(modifierKeywordToken);
            if (!hasModifier.invoke(modifierKeywordToken).booleanValue()) continue;
            mask |= 1L << index;
        }
        return mask;
    }

    @JvmStatic
    public static final boolean maskHasModifier(long mask, @NotNull KtModifierKeywordToken modifierToken) {
        boolean bl;
        Intrinsics.checkNotNullParameter(modifierToken, "modifierToken");
        Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
        int index = ArraysKt.indexOf((Object[])KtTokens.MODIFIER_KEYWORDS_ARRAY, modifierToken);
        boolean bl2 = bl = index >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "All KtModifierKeywordTokens should be present in MODIFIER_KEYWORDS_ARRAY";
            throw new AssertionError((Object)string2);
        }
        return (mask & 1L << index) != 0L;
    }

    @JvmStatic
    @NotNull
    public static final String maskToString(long mask) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first2 = true;
        Iterator<KtModifierKeywordToken> iterator2 = ArrayIteratorKt.iterator(KtTokens.MODIFIER_KEYWORDS_ARRAY);
        while (iterator2.hasNext()) {
            KtModifierKeywordToken modifierKeyword = iterator2.next();
            Intrinsics.checkNotNull(modifierKeyword);
            if (!ModifierMaskUtils.maskHasModifier(mask, modifierKeyword)) continue;
            if (!first2) {
                sb.append(" ");
            }
            sb.append(modifierKeyword.getValue());
            first2 = false;
        }
        sb.append("]");
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final boolean computeMaskFromModifierList$lambda$1(KtModifierList $modifierList, KtModifierKeywordToken it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $modifierList.hasModifier(it);
    }

    static {
        boolean bl;
        INSTANCE = new ModifierMaskUtils();
        boolean bl2 = bl = KtTokens.MODIFIER_KEYWORDS_ARRAY.length <= 64;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Current implementation depends on the ability to represent modifier list as bit mask";
            throw new AssertionError((Object)string2);
        }
    }
}

