/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecationInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class DeprecationInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final DeprecationInheritanceChecker INSTANCE = new DeprecationInheritanceChecker();

    private DeprecationInheritanceChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        if (declaration instanceof KtProperty && descriptor2 instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)descriptor2).isDefault()) {
            return;
        }
        DeprecationResolver deprecationResolver = context.getDeprecationResolver();
        if (!deprecationResolver.areDeprecationsInheritedFromOverriden(descriptor2)) {
            return;
        }
        Pair<List<DescriptorBasedDeprecationInfo>, String> pair = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.StopPropagatingDeprecationThroughOverrides) ? TuplesKt.to(deprecationResolver.getHiddenDeprecationsFromOverriden(descriptor2), "") : TuplesKt.to(deprecationResolver.getDeprecations(descriptor2), "This deprecation won't be inherited in future releases. ");
        List<DescriptorBasedDeprecationInfo> deprecations = pair.component1();
        String message = pair.component2();
        context.getTrace().report(Errors.OVERRIDE_DEPRECATION.on((KtNamedDeclaration)declaration, message, (CallableMemberDescriptor)descriptor2, deprecations));
    }
}

