/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/UnsupportedSyntheticCallableReferenceChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class UnsupportedSyntheticCallableReferenceChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
        KtCallableReferenceExpression ktCallableReferenceExpression = CallUtilKt.extractCallableReferenceExpression(call2);
        if (ktCallableReferenceExpression == null) {
            return;
        }
        KtCallableReferenceExpression callableReferenceExpression = ktCallableReferenceExpression;
        if (PsiUtilsKt.unwrapParenthesesLabelsAndAnnotationsDeeply(callableReferenceExpression) instanceof KtPropertyDelegate) {
            return;
        }
        if (resolvedCall2.getResultingDescriptor() instanceof SyntheticJavaPropertyDescriptor) {
            if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReferencesToSyntheticJavaProperties)) {
                context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(reportOn, TuplesKt.to(LanguageFeature.ReferencesToSyntheticJavaProperties, context.getLanguageVersionSettings())));
            } else if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
                context.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(reportOn, TuplesKt.to(LanguageFeature.NewInference, context.getLanguageVersionSettings())));
            }
        }
    }
}

