/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.AbstractStubType;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.DelegatingSimpleType;
import org.jetbrains.kotlin.types.ErasureTypeAttributes;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.StarProjectionImplKt;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUsage;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.checker.NewTypeVariableConstructor;
import org.jetbrains.kotlin.types.error.ErrorType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.SmartSet;

public class TypeUtils {
    public static final SimpleType DONT_CARE = ErrorUtils.createErrorType(ErrorTypeKind.DONT_CARE, new String[0]);
    public static final SimpleType CANNOT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType(ErrorTypeKind.UNINFERRED_LAMBDA_PARAMETER_TYPE, new String[0]);
    @NotNull
    public static final SimpleType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final SimpleType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(0);
        }
        return type2 == NO_EXPECTED_TYPE || type2 == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() == DONT_CARE.getConstructor();
    }

    @NotNull
    public static KotlinType makeNullable(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(1);
        }
        return TypeUtils.makeNullableAsSpecified(type2, true);
    }

    @NotNull
    public static KotlinType makeNotNullable(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(2);
        }
        return TypeUtils.makeNullableAsSpecified(type2, false);
    }

    @NotNull
    public static KotlinType makeNullableAsSpecified(@NotNull KotlinType type2, boolean nullable) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(3);
        }
        UnwrappedType unwrappedType = type2.unwrap().makeNullableAsSpecified(nullable);
        if (unwrappedType == null) {
            TypeUtils.$$$reportNull$$$0(4);
        }
        return unwrappedType;
    }

    @NotNull
    public static SimpleType makeNullableIfNeeded(@NotNull SimpleType type2, boolean nullable) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(5);
        }
        if (nullable) {
            SimpleType simpleType = type2.makeNullableAsSpecified(true);
            if (simpleType == null) {
                TypeUtils.$$$reportNull$$$0(6);
            }
            return simpleType;
        }
        SimpleType simpleType = type2;
        if (simpleType == null) {
            TypeUtils.$$$reportNull$$$0(7);
        }
        return simpleType;
    }

    @NotNull
    public static KotlinType makeNullableIfNeeded(@NotNull KotlinType type2, boolean nullable) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(8);
        }
        if (nullable) {
            return TypeUtils.makeNullable(type2);
        }
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(9);
        }
        return kotlinType;
    }

    public static boolean canHaveSubtypes(KotlinTypeChecker typeChecker, @NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(10);
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (!type2.getConstructor().isFinal()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters = type2.getConstructor().getParameters();
        List<TypeProjection> arguments = type2.getArguments();
        int parametersSize = parameters.size();
        block10: for (int i2 = 0; i2 < parametersSize; ++i2) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i2);
            TypeProjection typeProjection = arguments.get(i2);
            if (typeProjection.isStarProjection()) {
                return true;
            }
            Variance projectionKind = typeProjection.getProjectionKind();
            KotlinType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(KotlinTypeChecker typeChecker, KotlinType argument, TypeParameterDescriptor parameterDescriptor) {
        for (KotlinType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SimpleType makeUnsubstitutedType(ClassifierDescriptor classifierDescriptor, MemberScope unsubstitutedMemberScope, Function1<KotlinTypeRefiner, SimpleType> refinedTypeFactory) {
        if (ErrorUtils.isError(classifierDescriptor)) {
            ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.UNABLE_TO_SUBSTITUTE_TYPE, classifierDescriptor.toString());
            if (errorType == null) {
                TypeUtils.$$$reportNull$$$0(11);
            }
            return errorType;
        }
        TypeConstructor typeConstructor2 = classifierDescriptor.getTypeConstructor();
        return TypeUtils.makeUnsubstitutedType(typeConstructor2, unsubstitutedMemberScope, refinedTypeFactory);
    }

    @NotNull
    public static SimpleType makeUnsubstitutedType(@NotNull TypeConstructor typeConstructor2, @NotNull MemberScope unsubstitutedMemberScope, @NotNull Function1<KotlinTypeRefiner, SimpleType> refinedTypeFactory) {
        if (typeConstructor2 == null) {
            TypeUtils.$$$reportNull$$$0(12);
        }
        if (unsubstitutedMemberScope == null) {
            TypeUtils.$$$reportNull$$$0(13);
        }
        if (refinedTypeFactory == null) {
            TypeUtils.$$$reportNull$$$0(14);
        }
        List<TypeProjection> arguments = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        SimpleType simpleType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), typeConstructor2, arguments, false, unsubstitutedMemberScope, refinedTypeFactory);
        if (simpleType == null) {
            TypeUtils.$$$reportNull$$$0(15);
        }
        return simpleType;
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(@NotNull List<TypeParameterDescriptor> parameters) {
        if (parameters == null) {
            TypeUtils.$$$reportNull$$$0(16);
        }
        ArrayList<TypeProjectionImpl> result2 = new ArrayList<TypeProjectionImpl>(parameters.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result2.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        List<TypeProjection> list = kotlin.collections.CollectionsKt.toList(result2);
        if (list == null) {
            TypeUtils.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public static List<KotlinType> getImmediateSupertypes(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(18);
        }
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(type2);
        Collection<KotlinType> originalSupertypes = type2.getConstructor().getSupertypes();
        ArrayList<KotlinType> result2 = new ArrayList<KotlinType>(originalSupertypes.size());
        for (KotlinType supertype : originalSupertypes) {
            KotlinType substitutedType = TypeUtils.createSubstitutedSupertype(type2, supertype, substitutor2);
            if (substitutedType == null) continue;
            result2.add(substitutedType);
        }
        ArrayList<KotlinType> arrayList = result2;
        if (arrayList == null) {
            TypeUtils.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Nullable
    public static KotlinType createSubstitutedSupertype(@NotNull KotlinType subType, @NotNull KotlinType superType, @NotNull TypeSubstitutor substitutor2) {
        KotlinType substitutedType;
        if (subType == null) {
            TypeUtils.$$$reportNull$$$0(20);
        }
        if (superType == null) {
            TypeUtils.$$$reportNull$$$0(21);
        }
        if (substitutor2 == null) {
            TypeUtils.$$$reportNull$$$0(22);
        }
        if ((substitutedType = substitutor2.substitute(superType, Variance.INVARIANT)) != null) {
            return TypeUtils.makeNullableIfNeeded(substitutedType, subType.isMarkedNullable());
        }
        return null;
    }

    private static void collectAllSupertypes(@NotNull KotlinType type2, @NotNull Set<KotlinType> result2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            TypeUtils.$$$reportNull$$$0(24);
        }
        List<KotlinType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type2);
        result2.addAll(immediateSupertypes);
        for (KotlinType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result2);
        }
    }

    @NotNull
    public static Set<KotlinType> getAllSupertypes(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(25);
        }
        LinkedHashSet<KotlinType> result2 = new LinkedHashSet<KotlinType>(15);
        TypeUtils.collectAllSupertypes(type2, result2);
        LinkedHashSet<KotlinType> linkedHashSet = result2;
        if (linkedHashSet == null) {
            TypeUtils.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    public static boolean isNullableType(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(27);
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(type2)) {
            return false;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableSuperType(type2);
        }
        if (type2 instanceof AbstractStubType) {
            NewTypeVariableConstructor typeVariableConstructor = ((AbstractStubType)type2).getOriginalTypeVariable();
            TypeParameterDescriptor typeParameter = typeVariableConstructor.getOriginalTypeParameter();
            return typeParameter == null || TypeUtils.hasNullableSuperType(typeParameter.getDefaultType());
        }
        TypeConstructor constructor = type2.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            for (KotlinType supertype : constructor.getSupertypes()) {
                if (!TypeUtils.isNullableType(supertype)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean acceptsNullable(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(28);
        }
        if (type2.isMarkedNullable()) {
            return true;
        }
        return FlexibleTypesKt.isFlexible(type2) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
    }

    public static boolean hasNullableSuperType(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(29);
        }
        if (type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (KotlinType supertype : TypeUtils.getImmediateSupertypes(type2)) {
            if (!TypeUtils.isNullableType(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull KotlinType type2) {
        ClassifierDescriptor declarationDescriptor;
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(30);
        }
        if ((declarationDescriptor = type2.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static KotlinType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<KotlinType> typeArguments) {
        if (clazz == null) {
            TypeUtils.$$$reportNull$$$0(31);
        }
        if (typeArguments == null) {
            TypeUtils.$$$reportNull$$$0(32);
        }
        List<TypeProjection> projections = kotlin.collections.CollectionsKt.map(typeArguments, new Function1<KotlinType, TypeProjection>(){

            @Override
            public TypeProjection invoke(KotlinType type2) {
                return new TypeProjectionImpl(type2);
            }
        });
        return TypeUtils.substituteProjectionsForParameters(clazz, projections);
    }

    @NotNull
    public static KotlinType substituteProjectionsForParameters(@NotNull ClassDescriptor clazz, @NotNull List<TypeProjection> projections) {
        List<TypeParameterDescriptor> clazzTypeParameters;
        if (clazz == null) {
            TypeUtils.$$$reportNull$$$0(33);
        }
        if (projections == null) {
            TypeUtils.$$$reportNull$$$0(34);
        }
        if ((clazzTypeParameters = clazz.getTypeConstructor().getParameters()).size() != projections.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + projections);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = CollectionsKt.newHashMapWithExpectedSize(clazzTypeParameters.size());
        for (int i2 = 0; i2 < clazzTypeParameters.size(); ++i2) {
            TypeConstructor typeConstructor2 = clazzTypeParameters.get(i2).getTypeConstructor();
            substitutions.put(typeConstructor2, projections.get(i2));
        }
        KotlinType kotlinType = TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(35);
        }
        return kotlinType;
    }

    public static boolean equalTypes(@NotNull KotlinType a2, @NotNull KotlinType b2) {
        if (a2 == null) {
            TypeUtils.$$$reportNull$$$0(36);
        }
        if (b2 == null) {
            TypeUtils.$$$reportNull$$$0(37);
        }
        return KotlinTypeChecker.DEFAULT.equalTypes(a2, b2);
    }

    public static boolean dependsOnTypeParameters(@NotNull KotlinType type2, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(38);
        }
        if (typeParameters == null) {
            TypeUtils.$$$reportNull$$$0(39);
        }
        return TypeUtils.dependsOnTypeConstructors(type2, kotlin.collections.CollectionsKt.map(typeParameters, new Function1<TypeParameterDescriptor, TypeConstructor>(){

            @Override
            public TypeConstructor invoke(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
                if (typeParameterDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                return typeParameterDescriptor.getTypeConstructor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/types/TypeUtils$2", "invoke"));
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull KotlinType type2, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(40);
        }
        if (typeParameterConstructors == null) {
            TypeUtils.$$$reportNull$$$0(41);
        }
        if (typeParameterConstructors.contains(type2.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection() || !TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(@Nullable KotlinType type2, final @NotNull KotlinType specialType) {
        if (specialType == null) {
            TypeUtils.$$$reportNull$$$0(42);
        }
        return TypeUtils.contains(type2, new Function1<UnwrappedType, Boolean>(){

            @Override
            public Boolean invoke(UnwrappedType type2) {
                return specialType.equals(type2);
            }
        });
    }

    public static boolean contains(@Nullable KotlinType type2, @NotNull Function1<UnwrappedType, Boolean> isSpecialType) {
        if (isSpecialType == null) {
            TypeUtils.$$$reportNull$$$0(43);
        }
        return TypeUtils.contains(type2, isSpecialType, null);
    }

    private static boolean contains(@Nullable KotlinType type2, @NotNull Function1<UnwrappedType, Boolean> isSpecialType, SmartSet<KotlinType> visited2) {
        FlexibleType flexibleType;
        if (isSpecialType == null) {
            TypeUtils.$$$reportNull$$$0(44);
        }
        if (type2 == null) {
            return false;
        }
        UnwrappedType unwrappedType = type2.unwrap();
        if (TypeUtils.noExpectedType(type2)) {
            return isSpecialType.invoke(unwrappedType);
        }
        if (visited2 != null && visited2.contains(type2)) {
            return false;
        }
        if (isSpecialType.invoke(unwrappedType).booleanValue()) {
            return true;
        }
        if (visited2 == null) {
            visited2 = SmartSet.create();
        }
        visited2.add(type2);
        FlexibleType flexibleType2 = flexibleType = unwrappedType instanceof FlexibleType ? (FlexibleType)unwrappedType : null;
        if (flexibleType != null && (TypeUtils.contains(flexibleType.getLowerBound(), isSpecialType, visited2) || TypeUtils.contains(flexibleType.getUpperBound(), isSpecialType, visited2))) {
            return true;
        }
        if (unwrappedType instanceof DefinitelyNotNullType && TypeUtils.contains(((DefinitelyNotNullType)unwrappedType).getOriginal(), isSpecialType, visited2)) {
            return true;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            IntersectionTypeConstructor intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor2;
            for (KotlinType supertype : intersectionTypeConstructor.getSupertypes()) {
                if (!TypeUtils.contains(supertype, isSpecialType, visited2)) continue;
                return true;
            }
            return false;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !TypeUtils.contains(projection.getType(), isSpecialType, visited2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor == null) {
            TypeUtils.$$$reportNull$$$0(45);
        }
        return new StarProjectionImpl(parameterDescriptor);
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor, ErasureTypeAttributes attr) {
        if (parameterDescriptor == null) {
            TypeUtils.$$$reportNull$$$0(46);
        }
        if (attr.getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE) {
            return new TypeProjectionImpl(StarProjectionImplKt.starProjectionType(parameterDescriptor));
        }
        return new StarProjectionImpl(parameterDescriptor);
    }

    @NotNull
    public static KotlinType getDefaultPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor) {
        if (numberValueTypeConstructor == null) {
            TypeUtils.$$$reportNull$$$0(47);
        }
        KotlinType type2 = TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor.getSupertypes());
        assert (type2 != null) : "Strange number value type constructor: " + numberValueTypeConstructor + ". Super types doesn't contain double, int or long: " + numberValueTypeConstructor.getSupertypes();
        KotlinType kotlinType = type2;
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(48);
        }
        return kotlinType;
    }

    @Nullable
    public static KotlinType getDefaultPrimitiveNumberType(@NotNull Collection<KotlinType> supertypes) {
        if (supertypes == null) {
            TypeUtils.$$$reportNull$$$0(49);
        }
        if (supertypes.isEmpty()) {
            return null;
        }
        KotlinBuiltIns builtIns = supertypes.iterator().next().getConstructor().getBuiltIns();
        SimpleType doubleType = builtIns.getDoubleType();
        if (supertypes.contains(doubleType)) {
            return doubleType;
        }
        SimpleType intType = builtIns.getIntType();
        if (supertypes.contains(intType)) {
            return intType;
        }
        SimpleType longType = builtIns.getLongType();
        if (supertypes.contains(longType)) {
            return longType;
        }
        KotlinType uIntType = TypeUtils.findByFqName(supertypes, StandardNames.FqNames.uIntFqName);
        if (uIntType != null) {
            return uIntType;
        }
        KotlinType uLongType = TypeUtils.findByFqName(supertypes, StandardNames.FqNames.uLongFqName);
        if (uLongType != null) {
            return uLongType;
        }
        return null;
    }

    @Nullable
    private static KotlinType findByFqName(@NotNull Collection<KotlinType> supertypes, FqName fqName) {
        if (supertypes == null) {
            TypeUtils.$$$reportNull$$$0(50);
        }
        for (KotlinType supertype : supertypes) {
            FqNameUnsafe descriptorFqName;
            ClassifierDescriptor descriptor2 = supertype.getConstructor().getDeclarationDescriptor();
            if (descriptor2 == null || !(descriptorFqName = DescriptorUtils.getFqName(descriptor2)).equals(fqName.toUnsafe())) continue;
            return supertype;
        }
        return null;
    }

    @NotNull
    public static KotlinType getPrimitiveNumberType(@NotNull IntegerValueTypeConstructor numberValueTypeConstructor, @NotNull KotlinType expectedType) {
        if (numberValueTypeConstructor == null) {
            TypeUtils.$$$reportNull$$$0(51);
        }
        if (expectedType == null) {
            TypeUtils.$$$reportNull$$$0(52);
        }
        if (TypeUtils.noExpectedType(expectedType) || KotlinTypeKt.isError(expectedType)) {
            return TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
        }
        for (KotlinType primitiveNumberType : numberValueTypeConstructor.getSupertypes()) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            KotlinType kotlinType = primitiveNumberType;
            if (kotlinType == null) {
                TypeUtils.$$$reportNull$$$0(53);
            }
            return kotlinType;
        }
        return TypeUtils.getDefaultPrimitiveNumberType(numberValueTypeConstructor);
    }

    @NotNull
    public static KotlinType getPrimitiveNumberType(@NotNull IntegerLiteralTypeConstructor literalTypeConstructor, @NotNull KotlinType expectedType) {
        if (literalTypeConstructor == null) {
            TypeUtils.$$$reportNull$$$0(54);
        }
        if (expectedType == null) {
            TypeUtils.$$$reportNull$$$0(55);
        }
        if (TypeUtils.noExpectedType(expectedType) || KotlinTypeKt.isError(expectedType)) {
            KotlinType kotlinType = literalTypeConstructor.getApproximatedType();
            if (kotlinType == null) {
                TypeUtils.$$$reportNull$$$0(56);
            }
            return kotlinType;
        }
        KotlinType approximatedType = literalTypeConstructor.getApproximatedType();
        if (KotlinTypeChecker.DEFAULT.isSubtypeOf(approximatedType, expectedType)) {
            KotlinType kotlinType = approximatedType;
            if (kotlinType == null) {
                TypeUtils.$$$reportNull$$$0(57);
            }
            return kotlinType;
        }
        for (KotlinType primitiveNumberType : literalTypeConstructor.getPossibleTypes()) {
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(primitiveNumberType, expectedType)) continue;
            KotlinType kotlinType = primitiveNumberType;
            if (kotlinType == null) {
                TypeUtils.$$$reportNull$$$0(58);
            }
            return kotlinType;
        }
        KotlinType kotlinType = literalTypeConstructor.getApproximatedType();
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(59);
        }
        return kotlinType;
    }

    public static boolean isTypeParameter(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(60);
        }
        return TypeUtils.getTypeParameterDescriptorOrNull(type2) != null || type2.getConstructor() instanceof NewTypeVariableConstructor;
    }

    public static boolean isReifiedTypeParameter(@NotNull KotlinType type2) {
        TypeParameterDescriptor typeParameterDescriptor;
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(61);
        }
        return (typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2)) != null && typeParameterDescriptor.isReified();
    }

    public static boolean isNonReifiedTypeParameter(@NotNull KotlinType type2) {
        TypeParameterDescriptor typeParameterDescriptor;
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(62);
        }
        return (typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2)) != null && !typeParameterDescriptor.isReified();
    }

    @Nullable
    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(@NotNull KotlinType type2) {
        if (type2 == null) {
            TypeUtils.$$$reportNull$$$0(63);
        }
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/TypeUtils";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsubstitutedMemberScope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refinedTypeFactory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projections";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterConstructors";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialType";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSpecialType";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberValueTypeConstructor";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalTypeConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/TypeUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNullableAsSpecified";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNullableIfNeeded";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "makeUnsubstitutedType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeProjections";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateSupertypes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSupertypes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteProjectionsForParameters";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPrimitiveNumberType";
                break;
            }
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveNumberType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "noExpectedType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "makeNullable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeNotNullable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeNullableAsSpecified";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeNullableIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSubtypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeUnsubstitutedType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeProjections";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateSupertypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutedSupertype";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectAllSupertypes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllSupertypes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isNullableType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "acceptsNullable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasNullableSuperType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "substituteParameters";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "substituteProjectionsForParameters";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "equalTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnTypeParameters";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnTypeConstructors";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "makeStarProjection";
                break;
            }
            case 47: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrimitiveNumberType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findByFqName";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveNumberType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isTypeParameter";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isReifiedTypeParameter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isNonReifiedTypeParameter";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDescriptorOrNull";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SpecialType
    extends DelegatingSimpleType {
        private final String name;

        public SpecialType(String name2) {
            this.name = name2;
        }

        @Override
        @NotNull
        protected SimpleType getDelegate() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public SimpleType replaceAttributes(@NotNull TypeAttributes newAttributes) {
            if (newAttributes == null) {
                SpecialType.$$$reportNull$$$0(0);
            }
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public SimpleType makeNullableAsSpecified(boolean newNullability) {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public String toString() {
            String string2 = this.name;
            if (string2 == null) {
                SpecialType.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        @NotNull
        @TypeRefinement
        public DelegatingSimpleType replaceDelegate(@NotNull SimpleType delegate2) {
            if (delegate2 == null) {
                SpecialType.$$$reportNull$$$0(2);
            }
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        @TypeRefinement
        public SpecialType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
            if (kotlinTypeRefiner == null) {
                SpecialType.$$$reportNull$$$0(3);
            }
            SpecialType specialType = this;
            if (specialType == null) {
                SpecialType.$$$reportNull$$$0(4);
            }
            return specialType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newAttributes";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/types/TypeUtils$SpecialType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kotlinTypeRefiner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/types/TypeUtils$SpecialType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceAttributes";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceDelegate";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "refine";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

