/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u001c\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ6\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050%H\u0086\b\u00f8\u0001\u0000J6\u0010&\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050%H\u0086\b\u00f8\u0001\u0000J)\u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010*\u001a\u00020\u0005J\u0012\u0010\u001f\u001a\u00020\u000f2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010+\u001a\u00020\u0005J\u001e\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ>\u0010/\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u000f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u0010\b\u001a\u00020\tJ\u0016\u00106\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u0016\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u001c\u00109\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J*\u0010:\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J\u0016\u0010>\u001a\u00020=2\u0006\u00108\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fJ\u000e\u0010?\u001a\u00020=2\u0006\u0010.\u001a\u00020\u000fJ)\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u00020B2\u0006\u0010.\u001a\u00020\u000f2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010CJ\u000e\u0010D\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u000fJ\u0006\u0010E\u001a\u00020\u0005J\u0016\u0010F\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010G\u001a\u00020\u00052\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u001d2\u0006\u0010\b\u001a\u00020\tJ,\u0010J\u001a\u00020\u00052\f\u0010H\u001a\b\u0012\u0004\u0012\u00020K0\u001d2\u000e\b\u0002\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0M2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020P2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010Q\u001a\u00020\u00052\u0006\u0010O\u001a\u00020P2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010R\u001a\u00020\u00052\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u001d2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010U\u001a\u00020\u00052\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u001d2\u0006\u0010\b\u001a\u00020\tJ*\u0010V\u001a\u00020\u00052\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u001d2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010Z\u001a\u00020\u00052\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u001d2\u0006\u0010\b\u001a\u00020\tJ*\u0010[\u001a\u00020\u00052\f\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u001d2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001d2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\\\u001a\u00020\u00052\f\u0010]\u001a\b\u0012\u0004\u0012\u00020X0M2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010^\u001a\u00020\u00052\f\u0010]\u001a\b\u0012\u0004\u0012\u00020X0M2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010_\u001a\u00020\u00052\f\u0010]\u001a\b\u0012\u0004\u0012\u00020X0M2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010`\u001a\u00020\u00052\u0006\u0010a\u001a\u0002042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010c\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010d\u001a\u00020\u00052\f\u0010e\u001a\b\u0012\u0004\u0012\u00020!0fH\u0086\b\u00f8\u0001\u0000J\u001a\u0010g\u001a\u00020\u00052\f\u0010e\u001a\b\u0012\u0004\u0012\u00020!0fH\u0086\b\u00f8\u0001\u0000J\u0006\u0010h\u001a\u00020\u0005R\u0018\u0010\u000e\u001a\u00020\u000fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006i"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "", "<init>", "()V", "buildInstr", "", "op", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "numberOfNestedBlocks", "", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "buildConstI32", "value", "buildConstI64", "", "buildConstF32", "", "buildConstF64", "", "buildConstI32Symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "buildUnreachable", "buildBlock", "label", "", "resultType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "body", "Lkotlin/Function1;", "buildLoop", "buildInstrWithNoLocation", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildIf", "buildElse", "buildEnd", "buildBrInstr", "brOp", "absoluteBlockLevel", "buildBrOnCastInstr", "fromIsNullable", "", "toIsNullable", "from", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType;", "to", "buildBr", "buildThrow", "tagIdx", "buildTry", "buildTryTable", "catches", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch;", "createNewCatch", "createNewCatchAll", "createNewCatchImmediate", "catchType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch$CatchType;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch$CatchType;ILjava/lang/Integer;)Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$Catch;", "buildCatch", "buildCatchAll", "buildBrIf", "buildCall", "symbol", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "buildCallIndirect", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "tableIdx", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbolReadOnly;", "buildGetLocal", "local", "Lorg/jetbrains/kotlin/wasm/ir/WasmLocal;", "buildSetLocal", "buildGetGlobal", "global", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "buildSetGlobal", "buildStructGet", "struct", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "fieldId", "buildStructNew", "buildStructSet", "buildRefCastNullStatic", "toType", "buildRefCastStatic", "buildRefTestStatic", "buildRefNull", "type", "buildDrop", "buildNop", "commentPreviousInstr", "text", "Lkotlin/Function0;", "commentGroupStart", "commentGroupEnd", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,278:1\n1#2:279\n37#3,2:280\n*S KotlinDebug\n*F\n+ 1 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n148#1:280,2\n*E\n"})
public abstract class WasmExpressionBuilder {
    public abstract void buildInstr(@NotNull WasmOp var1, @NotNull SourceLocation var2, WasmImmediate ... var3);

    public abstract int getNumberOfNestedBlocks();

    public abstract void setNumberOfNestedBlocks(int var1);

    public final void buildConstI32(int value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI32(value2)};
        this.buildInstr(WasmOp.I32_CONST, location, wasmImmediateArray);
    }

    public final void buildConstI64(long value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstI64(value2)};
        this.buildInstr(WasmOp.I64_CONST, location, wasmImmediateArray);
    }

    public final void buildConstF32(float value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF32(UInt.constructor-impl(Float.floatToRawIntBits(value2)), null)};
        this.buildInstr(WasmOp.F32_CONST, location, wasmImmediateArray);
    }

    public final void buildConstF64(double value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstF64(ULong.constructor-impl(Double.doubleToRawLongBits(value2)), null)};
        this.buildInstr(WasmOp.F64_CONST, location, wasmImmediateArray);
    }

    public final void buildConstI32Symbol(@NotNull WasmSymbol<Integer> value2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.SymbolI32(value2)};
        this.buildInstr(WasmOp.I32_CONST, location, wasmImmediateArray);
    }

    public final void buildUnreachable(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.buildInstr(WasmOp.UNREACHABLE, location, new WasmImmediate[0]);
    }

    public final void buildBlock(@Nullable String label2, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$buildBlock = false;
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body2.invoke((Integer)this.getNumberOfNestedBlocks());
        this.buildEnd();
    }

    public static /* synthetic */ void buildBlock$default(WasmExpressionBuilder $this, String label2, WasmType resultType, Function1 body2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$buildBlock = false;
        int n2 = $this.getNumberOfNestedBlocks();
        $this.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        $this.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        body2.invoke($this.getNumberOfNestedBlocks());
        $this.buildEnd();
    }

    public final void buildLoop(@Nullable String label2, @Nullable WasmType resultType, @NotNull Function1<? super Integer, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$buildLoop = false;
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        body2.invoke((Integer)this.getNumberOfNestedBlocks());
        this.buildEnd();
    }

    public static /* synthetic */ void buildLoop$default(WasmExpressionBuilder $this, String label2, WasmType resultType, Function1 body2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildLoop");
        }
        if ((n & 2) != 0) {
            resultType = null;
        }
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$buildLoop = false;
        int n2 = $this.getNumberOfNestedBlocks();
        $this.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        $this.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        body2.invoke($this.getNumberOfNestedBlocks());
        $this.buildEnd();
    }

    private final void buildInstrWithNoLocation(WasmOp op, WasmImmediate ... immediates) {
        this.buildInstr(op, SourceLocation.Companion.NoLocation(op.getMnemonic()), Arrays.copyOf(immediates, immediates.length));
    }

    public final void buildIf(@Nullable String label2, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.IF, wasmImmediateArray);
    }

    public static /* synthetic */ void buildIf$default(WasmExpressionBuilder wasmExpressionBuilder, String string2, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildIf");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildIf(string2, wasmType);
    }

    public final void buildElse() {
        this.buildInstrWithNoLocation(WasmOp.ELSE, new WasmImmediate[0]);
    }

    public final int buildBlock(@Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.BLOCK, wasmImmediateArray);
        return this.getNumberOfNestedBlocks();
    }

    public static /* synthetic */ int buildBlock$default(WasmExpressionBuilder wasmExpressionBuilder, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildBlock");
        }
        if ((n & 1) != 0) {
            wasmType = null;
        }
        return wasmExpressionBuilder.buildBlock(wasmType);
    }

    public final void buildEnd() {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + -1);
        this.buildInstrWithNoLocation(WasmOp.END, new WasmImmediate[0]);
    }

    public final void buildBrInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)brOp, "brOp");
        Intrinsics.checkNotNullParameter(location, "location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Negative relative block index";
            throw new AssertionError((Object)string2);
        }
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(relativeLevel)};
        this.buildInstr(brOp, location, wasmImmediateArray);
    }

    public final void buildBrOnCastInstr(@NotNull WasmOp brOp, int absoluteBlockLevel, boolean fromIsNullable, boolean toIsNullable, @NotNull WasmHeapType from2, @NotNull WasmHeapType to, @NotNull SourceLocation location) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)brOp, "brOp");
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(location, "location");
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = false;
            String $i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22 = "Negative relative block index";
            throw new AssertionError((Object)$i$a$-assert-WasmExpressionBuilder$buildBrOnCastInstr$22);
        }
        int fromTypeFlag = fromIsNullable ? 1 : 0;
        int toTypeFlag = toIsNullable ? 2 : 0;
        int flags = fromTypeFlag | toTypeFlag;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstU8(UByte.constructor-impl((byte)flags), null), new WasmImmediate.LabelIdx(relativeLevel), new WasmImmediate.HeapType(from2), new WasmImmediate.HeapType(to)};
        this.buildInstr(brOp, location, wasmImmediateArray);
    }

    public final void buildBr(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.buildBrInstr(WasmOp.BR, absoluteBlockLevel, location);
    }

    public final void buildThrow(int tagIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstr(WasmOp.THROW, location, wasmImmediateArray);
    }

    public final void buildTry(@Nullable String label2, @Nullable WasmType resultType) {
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this.buildInstrWithNoLocation(WasmOp.TRY, wasmImmediateArray);
    }

    public static /* synthetic */ void buildTry$default(WasmExpressionBuilder wasmExpressionBuilder, String string2, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTry");
        }
        if ((n & 2) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTry(string2, wasmType);
    }

    public final void buildTryTable(@Nullable String label2, @NotNull List<WasmImmediate.Catch> catches, @Nullable WasmType resultType) {
        Intrinsics.checkNotNullParameter(catches, "catches");
        int n = this.getNumberOfNestedBlocks();
        this.setNumberOfNestedBlocks(n + 1);
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.add(new WasmImmediate.BlockType.Value(resultType));
        spreadBuilder.add(new WasmImmediate.ConstI32(catches.size()));
        Collection $this$toTypedArray$iv = catches;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread(thisCollection$iv.toArray(new WasmImmediate.Catch[0]));
        this.buildInstrWithNoLocation(WasmOp.TRY_TABLE, (WasmImmediate[])spreadBuilder.toArray(new WasmImmediate[spreadBuilder.size()]));
    }

    public static /* synthetic */ void buildTryTable$default(WasmExpressionBuilder wasmExpressionBuilder, String string2, List list, WasmType wasmType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildTryTable");
        }
        if ((n & 4) != 0) {
            wasmType = null;
        }
        wasmExpressionBuilder.buildTryTable(string2, list, wasmType);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatch(int tagIdx, int absoluteBlockLevel) {
        return this.createNewCatchImmediate(WasmImmediate.Catch.CatchType.CATCH, absoluteBlockLevel, tagIdx);
    }

    @NotNull
    public final WasmImmediate.Catch createNewCatchAll(int absoluteBlockLevel) {
        return WasmExpressionBuilder.createNewCatchImmediate$default(this, WasmImmediate.Catch.CatchType.CATCH_ALL, absoluteBlockLevel, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final WasmImmediate.Catch createNewCatchImmediate(WasmImmediate.Catch.CatchType catchType, int absoluteBlockLevel, Integer tagIdx) {
        WasmImmediate.TableIdx tableIdx;
        WasmImmediate[] wasmImmediateArray;
        boolean bl;
        int relativeLevel = this.getNumberOfNestedBlocks() - absoluteBlockLevel;
        boolean bl2 = bl = relativeLevel >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Negative relative block index";
            throw new AssertionError((Object)string2);
        }
        WasmImmediate.Catch.CatchType catchType2 = catchType;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray = new WasmImmediate[2];
        int n = 0;
        Integer n2 = tagIdx;
        if (n2 != null) {
            void p0;
            int n3 = ((Number)n2).intValue();
            int n4 = n;
            WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
            WasmImmediate.Catch.CatchType catchType3 = catchType2;
            boolean bl4 = false;
            WasmImmediate.TableIdx tableIdx2 = new WasmImmediate.TableIdx((int)p0);
            catchType2 = catchType3;
            wasmImmediateArray2 = wasmImmediateArray3;
            n = n4;
            tableIdx = tableIdx2;
        } else {
            tableIdx = null;
        }
        wasmImmediateArray2[n] = tableIdx;
        wasmImmediateArray[1] = new WasmImmediate.LabelIdx(relativeLevel);
        List<WasmImmediate> list = CollectionsKt.listOfNotNull(wasmImmediateArray);
        WasmImmediate.Catch.CatchType catchType4 = catchType2;
        return new WasmImmediate.Catch(catchType4, list);
    }

    static /* synthetic */ WasmImmediate.Catch createNewCatchImmediate$default(WasmExpressionBuilder wasmExpressionBuilder, WasmImmediate.Catch.CatchType catchType, int n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createNewCatchImmediate");
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return wasmExpressionBuilder.createNewCatchImmediate(catchType, n, n2);
    }

    public final void buildCatch(int tagIdx) {
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TagIdx(tagIdx)};
        this.buildInstrWithNoLocation(WasmOp.CATCH, wasmImmediateArray);
    }

    public final void buildCatchAll() {
        this.buildInstrWithNoLocation(WasmOp.CATCH_ALL, new WasmImmediate[0]);
    }

    public final void buildBrIf(int absoluteBlockLevel, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.buildBrInstr(WasmOp.BR_IF, absoluteBlockLevel, location);
    }

    public final void buildCall(@NotNull WasmSymbol<? extends WasmFunction> symbol, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.FuncIdx(symbol)};
        this.buildInstr(WasmOp.CALL, location, wasmImmediateArray);
    }

    public final void buildCallIndirect(@NotNull WasmSymbol<WasmFunctionType> symbol, @NotNull WasmSymbolReadOnly<Integer> tableIdx, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(tableIdx, "tableIdx");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly<? extends WasmTypeDeclaration>)symbol), new WasmImmediate.TableIdx(tableIdx)};
        this.buildInstr(WasmOp.CALL_INDIRECT, location, wasmImmediateArray);
    }

    public static /* synthetic */ void buildCallIndirect$default(WasmExpressionBuilder wasmExpressionBuilder, WasmSymbol wasmSymbol, WasmSymbolReadOnly wasmSymbolReadOnly, SourceLocation sourceLocation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildCallIndirect");
        }
        if ((n & 2) != 0) {
            wasmSymbolReadOnly = new WasmSymbol<Integer>(0);
        }
        wasmExpressionBuilder.buildCallIndirect(wasmSymbol, wasmSymbolReadOnly, sourceLocation);
    }

    public final void buildGetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(local, "local");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_GET, location, wasmImmediateArray);
    }

    public final void buildSetLocal(@NotNull WasmLocal local, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(local, "local");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LocalIdx(local)};
        this.buildInstr(WasmOp.LOCAL_SET, location, wasmImmediateArray);
    }

    public final void buildGetGlobal(@NotNull WasmSymbol<WasmGlobal> global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(global, "global");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_GET, location, wasmImmediateArray);
    }

    public final void buildSetGlobal(@NotNull WasmSymbol<WasmGlobal> global, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(global, "global");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GlobalIdx(global)};
        this.buildInstr(WasmOp.GLOBAL_SET, location, wasmImmediateArray);
    }

    public final void buildStructGet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, "struct");
        Intrinsics.checkNotNullParameter(fieldId, "fieldId");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_GET, location, wasmImmediateArray);
    }

    public final void buildStructNew(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, "struct");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct)};
        this.buildInstr(WasmOp.STRUCT_NEW, location, wasmImmediateArray);
    }

    public final void buildStructSet(@NotNull WasmSymbol<? extends WasmTypeDeclaration> struct, @NotNull WasmSymbol<Integer> fieldId, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(struct, "struct");
        Intrinsics.checkNotNullParameter(fieldId, "fieldId");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(struct), new WasmImmediate.StructFieldIdx(fieldId)};
        this.buildInstr(WasmOp.STRUCT_SET, location, wasmImmediateArray);
    }

    public final void buildRefCastNullStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, "toType");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_CAST_NULL, location, wasmImmediateArray);
    }

    public final void buildRefCastStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, "toType");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_CAST, location, wasmImmediateArray);
    }

    public final void buildRefTestStatic(@NotNull WasmSymbolReadOnly<? extends WasmTypeDeclaration> toType, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(toType, "toType");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmHeapType.Type(toType))};
        this.buildInstr(WasmOp.REF_TEST, location, wasmImmediateArray);
    }

    public final void buildRefNull(@NotNull WasmHeapType type2, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(location, "location");
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(new WasmRefType(type2))};
        this.buildInstr(WasmOp.REF_NULL, location, wasmImmediateArray);
    }

    public final void buildDrop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.buildInstr(WasmOp.DROP, location, new WasmImmediate[0]);
    }

    public final void buildNop(@NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter(location, "location");
        this.buildInstr(WasmOp.NOP, location, new WasmImmediate[0]);
    }

    public final void commentPreviousInstr(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, "text");
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstString(text.invoke())};
        this.buildInstr(WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR, SourceLocation.Companion.NoLocation("Pseudo-instruction"), wasmImmediateArray);
    }

    public final void commentGroupStart(@NotNull Function0<String> text) {
        Intrinsics.checkNotNullParameter(text, "text");
        boolean $i$f$commentGroupStart = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.ConstString(text.invoke())};
        this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_START, SourceLocation.Companion.NoLocation("Pseudo-instruction"), wasmImmediateArray);
    }

    public final void commentGroupEnd() {
        this.buildInstr(WasmOp.PSEUDO_COMMENT_GROUP_END, SourceLocation.Companion.NoLocation("Pseudo-instruction"), new WasmImmediate[0]);
    }
}

