/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.constructor.core;

import java.math.BigInteger;
import org.snakeyaml.engine.v2.constructor.ConstructScalar;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;
import org.snakeyaml.engine.v2.nodes.Node;

public class ConstructYamlCoreInt
extends ConstructScalar {
    private static final int[][] RADIX_MAX;

    private static int maxLen(int max, int radix) {
        return Integer.toString(max, radix).length();
    }

    private static int maxLen(long max, int radix) {
        return Long.toString(max, radix).length();
    }

    protected static Number createLongOrBigInteger(String number, int radix) {
        try {
            return Long.valueOf(number, radix);
        }
        catch (NumberFormatException e1) {
            return new BigInteger(number, radix);
        }
    }

    @Override
    public Object construct(Node node) {
        String value2 = this.constructScalar(node);
        if (value2.isEmpty()) {
            throw new ConstructorException("while constructing an int", node.getStartMark(), "found empty value", node.getStartMark());
        }
        return this.createIntNumber(value2);
    }

    public Object createIntNumber(String value2) {
        int base2;
        int sign = 1;
        char first2 = value2.charAt(0);
        if (first2 == '-') {
            sign = -1;
            value2 = value2.substring(1);
        } else if (first2 == '+') {
            value2 = value2.substring(1);
        }
        if ("0".equals(value2)) {
            return 0;
        }
        if (value2.startsWith("0x")) {
            value2 = value2.substring(2);
            base2 = 16;
        } else if (value2.startsWith("0o")) {
            value2 = value2.substring(2);
            base2 = 8;
        } else {
            return this.createNumber(sign, value2, 10);
        }
        return this.createNumber(sign, value2, base2);
    }

    private Number createNumber(int sign, String number, int radix) {
        Number result2;
        int[] maxArr;
        int len;
        int n = len = number != null ? number.length() : 0;
        if (sign < 0) {
            number = "-" + number;
        }
        int[] nArray = maxArr = radix < RADIX_MAX.length ? RADIX_MAX[radix] : null;
        if (maxArr != null) {
            boolean gtInt;
            boolean bl = gtInt = len > maxArr[0];
            if (gtInt) {
                if (len > maxArr[1]) {
                    return new BigInteger(number, radix);
                }
                return ConstructYamlCoreInt.createLongOrBigInteger(number, radix);
            }
        }
        try {
            result2 = Integer.valueOf(number, radix);
        }
        catch (NumberFormatException e) {
            result2 = ConstructYamlCoreInt.createLongOrBigInteger(number, radix);
        }
        return result2;
    }

    static {
        int[] radixList;
        RADIX_MAX = new int[17][2];
        for (int radix : radixList = new int[]{8, 10, 16}) {
            ConstructYamlCoreInt.RADIX_MAX[radix] = new int[]{ConstructYamlCoreInt.maxLen(Integer.MAX_VALUE, radix), ConstructYamlCoreInt.maxLen(Long.MAX_VALUE, radix)};
        }
    }
}

