/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.msad;

import org.apache.commons.codec.binary.Hex;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.HexValueEditor;
import org.apache.directory.studio.valueeditors.msad.Messages;

public class InPlaceMsAdObjectSidValueEditor
extends HexValueEditor {
    public String getDisplayValue(IValue value) {
        Object rawValue;
        if (!this.showRawValues() && (rawValue = super.getRawValue(value)) instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            return this.convertToString(bytes);
        }
        return super.getDisplayValue(value);
    }

    protected String convertToString(byte[] bytes) {
        if (bytes == null || bytes.length < 8) {
            return Messages.getString("InPlaceMsAdObjectSidValueEditor.InvalidSid");
        }
        char[] hex = Hex.encodeHex((byte[])bytes);
        StringBuffer sb = new StringBuffer();
        sb.append('S');
        int revision = Integer.parseInt(new String(hex, 0, 2), 16);
        sb.append('-');
        sb.append(revision);
        int count = Integer.parseInt(new String(hex, 2, 2), 16);
        if (bytes.length != 8 + count * 4) {
            return Messages.getString("InPlaceMsAdObjectSidValueEditor.InvalidSid");
        }
        long authority = Long.parseLong(new String(hex, 4, 12), 16);
        sb.append('-');
        sb.append(authority);
        int i = 0;
        while (i < count) {
            StringBuffer rid = new StringBuffer();
            int k = 3;
            while (k >= 0) {
                rid.append(hex[16 + i * 8 + k * 2]);
                rid.append(hex[16 + i * 8 + k * 2 + 1]);
                --k;
            }
            long subAuthority = Long.parseLong(rid.toString(), 16);
            sb.append('-');
            sb.append(subAuthority);
            ++i;
        }
        return sb.toString();
    }
}

