/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.request;

import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.MonitorContendedEnterRequest;
import com.sun.jdi.request.MonitorContendedEnteredRequest;
import com.sun.jdi.request.MonitorWaitRequest;
import com.sun.jdi.request.MonitorWaitedRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.VMDeathRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdi.hcr.EventRequestManager;
import org.eclipse.jdi.hcr.ReenterStepRequest;
import org.eclipse.jdi.internal.FieldImpl;
import org.eclipse.jdi.internal.LocationImpl;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ReferenceTypeImpl;
import org.eclipse.jdi.internal.ThreadReferenceImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.event.AccessWatchpointEventImpl;
import org.eclipse.jdi.internal.event.BreakpointEventImpl;
import org.eclipse.jdi.internal.event.ClassPrepareEventImpl;
import org.eclipse.jdi.internal.event.ClassUnloadEventImpl;
import org.eclipse.jdi.internal.event.EventImpl;
import org.eclipse.jdi.internal.event.ExceptionEventImpl;
import org.eclipse.jdi.internal.event.MethodEntryEventImpl;
import org.eclipse.jdi.internal.event.MethodExitEventImpl;
import org.eclipse.jdi.internal.event.ModificationWatchpointEventImpl;
import org.eclipse.jdi.internal.event.MonitorContendedEnterEventImpl;
import org.eclipse.jdi.internal.event.MonitorContendedEnteredEventImpl;
import org.eclipse.jdi.internal.event.MonitorWaitEventImpl;
import org.eclipse.jdi.internal.event.MonitorWaitedEventImpl;
import org.eclipse.jdi.internal.event.StepEventImpl;
import org.eclipse.jdi.internal.event.ThreadDeathEventImpl;
import org.eclipse.jdi.internal.event.ThreadStartEventImpl;
import org.eclipse.jdi.internal.event.VMDeathEventImpl;
import org.eclipse.jdi.internal.request.AccessWatchpointRequestImpl;
import org.eclipse.jdi.internal.request.BreakpointRequestImpl;
import org.eclipse.jdi.internal.request.ClassPrepareRequestImpl;
import org.eclipse.jdi.internal.request.ClassUnloadRequestImpl;
import org.eclipse.jdi.internal.request.EventRequestImpl;
import org.eclipse.jdi.internal.request.ExceptionRequestImpl;
import org.eclipse.jdi.internal.request.MethodEntryRequestImpl;
import org.eclipse.jdi.internal.request.MethodExitRequestImpl;
import org.eclipse.jdi.internal.request.ModificationWatchpointRequestImpl;
import org.eclipse.jdi.internal.request.MonitorContendedEnterRequestImpl;
import org.eclipse.jdi.internal.request.MonitorContendedEnteredRequestImpl;
import org.eclipse.jdi.internal.request.MonitorWaitRequestImpl;
import org.eclipse.jdi.internal.request.MonitorWaitedRequestImpl;
import org.eclipse.jdi.internal.request.ReenterStepRequestImpl;
import org.eclipse.jdi.internal.request.RequestID;
import org.eclipse.jdi.internal.request.RequestMessages;
import org.eclipse.jdi.internal.request.StepRequestImpl;
import org.eclipse.jdi.internal.request.ThreadDeathRequestImpl;
import org.eclipse.jdi.internal.request.ThreadStartRequestImpl;
import org.eclipse.jdi.internal.request.VMDeathRequestImpl;
import org.eclipse.osgi.util.NLS;

public class EventRequestManagerImpl
extends MirrorImpl
implements com.sun.jdi.request.EventRequestManager,
EventRequestManager {
    private EventRequestType<AccessWatchpointRequest> ACCESS_WATCHPOINT_TYPE = new EventRequestType();
    private EventRequestType<BreakpointRequest> BREAKPOINT_TYPE = new EventRequestType();
    private EventRequestType<ClassPrepareRequest> CLASS_PREPARE_TYPE = new EventRequestType();
    private EventRequestType<ClassUnloadRequest> CLASS_UNLOAD_TYPE = new EventRequestType();
    private EventRequestType<MethodEntryRequest> METHOD_ENTRY_TYPE = new EventRequestType();
    private EventRequestType<MethodExitRequest> METHOD_EXIT_TYPE = new EventRequestType();
    private EventRequestType<ExceptionRequest> EXCEPTION_TYPE = new EventRequestType();
    private EventRequestType<ModificationWatchpointRequest> MODIFICATION_WATCHPOINT_TYPE = new EventRequestType();
    private EventRequestType<StepRequest> STEP_TYPE = new EventRequestType();
    private EventRequestType<ThreadDeathRequest> THREAD_DEATH_TYPE = new EventRequestType();
    private EventRequestType<ThreadStartRequest> THREAD_START_TYPE = new EventRequestType();
    private EventRequestType<VMDeathRequest> VM_DEATH_TYPE = new EventRequestType();
    private EventRequestType<MonitorContendedEnteredRequest> MONITOR_CONTENDED_ENTERED_TYPE = new EventRequestType();
    private EventRequestType<MonitorContendedEnterRequest> MONITOR_CONTENDED_ENTER_TYPE = new EventRequestType();
    private EventRequestType<MonitorWaitedRequest> MONITOR_WAITED_TYPE = new EventRequestType();
    private EventRequestType<MonitorWaitRequest> MONITOR_WAIT_TYPE = new EventRequestType();

    public EventRequestManagerImpl(VirtualMachineImpl vmImpl) {
        super("EventRequestManager", vmImpl);
    }

    @Override
    public AccessWatchpointRequest createAccessWatchpointRequest(Field field) {
        FieldImpl fieldImpl = (FieldImpl)field;
        AccessWatchpointRequestImpl req = new AccessWatchpointRequestImpl(this.virtualMachineImpl());
        req.addFieldFilter(fieldImpl);
        this.ACCESS_WATCHPOINT_TYPE.requests.add(req);
        return req;
    }

    @Override
    public BreakpointRequest createBreakpointRequest(Location location) throws VMMismatchException {
        LocationImpl locImpl = (LocationImpl)location;
        BreakpointRequestImpl req = new BreakpointRequestImpl(this.virtualMachineImpl());
        req.addLocationFilter(locImpl);
        this.BREAKPOINT_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ClassPrepareRequest createClassPrepareRequest() {
        ClassPrepareRequestImpl req = new ClassPrepareRequestImpl(this.virtualMachineImpl());
        this.CLASS_PREPARE_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ClassUnloadRequest createClassUnloadRequest() {
        ClassUnloadRequestImpl req = new ClassUnloadRequestImpl(this.virtualMachineImpl());
        this.CLASS_UNLOAD_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ExceptionRequest createExceptionRequest(ReferenceType refType, boolean notifyCaught, boolean notifyUncaught) {
        ReferenceTypeImpl refTypeImpl = (ReferenceTypeImpl)refType;
        ExceptionRequestImpl req = new ExceptionRequestImpl(this.virtualMachineImpl());
        req.addExceptionFilter(refTypeImpl, notifyCaught, notifyUncaught);
        this.EXCEPTION_TYPE.requests.add(req);
        return req;
    }

    @Override
    public MethodEntryRequest createMethodEntryRequest() {
        MethodEntryRequestImpl req = new MethodEntryRequestImpl(this.virtualMachineImpl());
        this.METHOD_ENTRY_TYPE.requests.add(req);
        return req;
    }

    @Override
    public MethodExitRequest createMethodExitRequest() {
        MethodExitRequestImpl req = new MethodExitRequestImpl(this.virtualMachineImpl());
        this.METHOD_EXIT_TYPE.requests.add(req);
        return req;
    }

    @Override
    public MonitorContendedEnteredRequest createMonitorContendedEnteredRequest() {
        MonitorContendedEnteredRequestImpl req = new MonitorContendedEnteredRequestImpl(this.virtualMachineImpl());
        this.MONITOR_CONTENDED_ENTERED_TYPE.requests.add(req);
        return req;
    }

    @Override
    public MonitorContendedEnterRequest createMonitorContendedEnterRequest() {
        MonitorContendedEnterRequestImpl req = new MonitorContendedEnterRequestImpl(this.virtualMachineImpl());
        this.MONITOR_CONTENDED_ENTER_TYPE.requests.add(req);
        return req;
    }

    @Override
    public MonitorWaitedRequest createMonitorWaitedRequest() {
        MonitorWaitedRequestImpl req = new MonitorWaitedRequestImpl(this.virtualMachineImpl());
        this.MONITOR_WAITED_TYPE.requests.add(req);
        return req;
    }

    @Override
    public MonitorWaitRequest createMonitorWaitRequest() {
        MonitorWaitRequestImpl req = new MonitorWaitRequestImpl(this.virtualMachineImpl());
        this.MONITOR_WAIT_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ModificationWatchpointRequest createModificationWatchpointRequest(Field field) {
        FieldImpl fieldImpl = (FieldImpl)field;
        ModificationWatchpointRequestImpl req = new ModificationWatchpointRequestImpl(this.virtualMachineImpl());
        req.addFieldFilter(fieldImpl);
        this.MODIFICATION_WATCHPOINT_TYPE.requests.add(req);
        return req;
    }

    @Override
    public StepRequest createStepRequest(ThreadReference thread, int size, int depth) throws DuplicateRequestException, ObjectCollectedException {
        ThreadReferenceImpl threadImpl = (ThreadReferenceImpl)thread;
        StepRequestImpl req = new StepRequestImpl(this.virtualMachineImpl());
        req.addStepFilter(threadImpl, size, depth);
        this.STEP_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ThreadDeathRequest createThreadDeathRequest() {
        ThreadDeathRequestImpl req = new ThreadDeathRequestImpl(this.virtualMachineImpl());
        this.THREAD_DEATH_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ThreadStartRequest createThreadStartRequest() {
        ThreadStartRequestImpl req = new ThreadStartRequestImpl(this.virtualMachineImpl());
        this.THREAD_START_TYPE.requests.add(req);
        return req;
    }

    @Override
    public VMDeathRequest createVMDeathRequest() {
        VMDeathRequestImpl req = new VMDeathRequestImpl(this.virtualMachineImpl());
        this.VM_DEATH_TYPE.requests.add(req);
        return req;
    }

    @Override
    public ReenterStepRequest createReenterStepRequest(ThreadReference thread) {
        this.virtualMachineImpl().checkHCRSupported();
        ThreadReferenceImpl threadImpl = (ThreadReferenceImpl)thread;
        ReenterStepRequestImpl req = new ReenterStepRequestImpl(this.virtualMachineImpl());
        req.addStepFilter(threadImpl, -1, 0);
        this.STEP_TYPE.requests.add(req);
        return req;
    }

    public void enableInternalClassPrepareEvent() {
        ClassPrepareRequestImpl requestPrepare = new ClassPrepareRequestImpl(this.virtualMachineImpl());
        requestPrepare.setGeneratedInside();
        requestPrepare.setSuspendPolicy(0);
        requestPrepare.enable();
    }

    public void enableInternalClasUnloadEvent() {
        ClassUnloadRequestImpl reqUnload = new ClassUnloadRequestImpl(this.virtualMachineImpl());
        reqUnload.setGeneratedInside();
        reqUnload.setSuspendPolicy(0);
        reqUnload.enable();
    }

    boolean existsEnabledStepRequest(ThreadReferenceImpl threadImpl) {
        Enumeration enumeration = this.STEP_TYPE.enabledrequests.elements();
        while (enumeration.hasMoreElements()) {
            StepRequestImpl step = (StepRequestImpl)enumeration.nextElement();
            if (step.thread() != threadImpl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteAllBreakpoints() {
        EventRequestImpl.clearAllBreakpoints(this);
        this.BREAKPOINT_TYPE.clear();
    }

    private void deleteEventRequest(EventRequestType<? extends EventRequest> type, EventRequestImpl req) throws VMMismatchException {
        this.checkVM(req);
        type.requests.remove(req);
        RequestID id = req.requestID();
        if (id != null) {
            type.enabledrequests.remove(id);
        }
    }

    @Override
    public void deleteEventRequest(EventRequest req) {
        try {
            req.disable();
        }
        catch (InvalidRequestStateException invalidRequestStateException) {}
        if (req instanceof AccessWatchpointRequestImpl) {
            this.deleteEventRequest(this.ACCESS_WATCHPOINT_TYPE, (AccessWatchpointRequestImpl)req);
        } else if (req instanceof BreakpointRequestImpl) {
            this.deleteEventRequest(this.BREAKPOINT_TYPE, (BreakpointRequestImpl)req);
        } else if (req instanceof ClassPrepareRequestImpl) {
            this.deleteEventRequest(this.CLASS_PREPARE_TYPE, (ClassPrepareRequestImpl)req);
        } else if (req instanceof ClassUnloadRequestImpl) {
            this.deleteEventRequest(this.CLASS_UNLOAD_TYPE, (ClassUnloadRequestImpl)req);
        } else if (req instanceof ExceptionRequestImpl) {
            this.deleteEventRequest(this.EXCEPTION_TYPE, (ExceptionRequestImpl)req);
        } else if (req instanceof MethodEntryRequestImpl) {
            this.deleteEventRequest(this.METHOD_ENTRY_TYPE, (MethodEntryRequestImpl)req);
        } else if (req instanceof MethodExitRequestImpl) {
            this.deleteEventRequest(this.METHOD_EXIT_TYPE, (MethodExitRequestImpl)req);
        } else if (req instanceof ModificationWatchpointRequestImpl) {
            this.deleteEventRequest(this.MODIFICATION_WATCHPOINT_TYPE, (ModificationWatchpointRequestImpl)req);
        } else if (req instanceof StepRequestImpl) {
            this.deleteEventRequest(this.STEP_TYPE, (StepRequestImpl)req);
        } else if (req instanceof ThreadDeathRequestImpl) {
            this.deleteEventRequest(this.THREAD_DEATH_TYPE, (ThreadDeathRequestImpl)req);
        } else if (req instanceof ThreadStartRequestImpl) {
            this.deleteEventRequest(this.THREAD_START_TYPE, (ThreadStartRequestImpl)req);
        } else if (req instanceof MonitorContendedEnterRequestImpl) {
            this.deleteEventRequest(this.MONITOR_CONTENDED_ENTER_TYPE, (MonitorContendedEnterRequestImpl)req);
        } else if (req instanceof MonitorContendedEnteredRequestImpl) {
            this.deleteEventRequest(this.MONITOR_CONTENDED_ENTERED_TYPE, (MonitorContendedEnteredRequestImpl)req);
        } else if (req instanceof MonitorWaitRequestImpl) {
            this.deleteEventRequest(this.MONITOR_WAIT_TYPE, (MonitorWaitRequestImpl)req);
        } else if (req instanceof MonitorWaitedRequestImpl) {
            this.deleteEventRequest(this.MONITOR_WAITED_TYPE, (MonitorWaitedRequestImpl)req);
        } else {
            throw new InternalError(NLS.bind((String)RequestMessages.EventRequestManagerImpl_EventRequest_type_of__0__is_unknown_1, (Object[])new String[]{req.toString()}));
        }
    }

    @Override
    public void deleteEventRequests(List<? extends EventRequest> requests) throws VMMismatchException {
        for (EventRequest eventRequest : requests) {
            this.deleteEventRequest(eventRequest);
        }
    }

    @Override
    public List<AccessWatchpointRequest> accessWatchpointRequests() {
        return this.ACCESS_WATCHPOINT_TYPE.getUnmodifiableList();
    }

    @Override
    public List<BreakpointRequest> breakpointRequests() {
        return this.BREAKPOINT_TYPE.getUnmodifiableList();
    }

    @Override
    public List<ClassPrepareRequest> classPrepareRequests() {
        return this.CLASS_PREPARE_TYPE.getUnmodifiableList();
    }

    @Override
    public List<ClassUnloadRequest> classUnloadRequests() {
        return this.CLASS_UNLOAD_TYPE.getUnmodifiableList();
    }

    @Override
    public List<ExceptionRequest> exceptionRequests() {
        return this.EXCEPTION_TYPE.getUnmodifiableList();
    }

    @Override
    public List<MethodEntryRequest> methodEntryRequests() {
        return this.METHOD_ENTRY_TYPE.getUnmodifiableList();
    }

    @Override
    public List<MethodExitRequest> methodExitRequests() {
        return this.METHOD_EXIT_TYPE.getUnmodifiableList();
    }

    @Override
    public List<ModificationWatchpointRequest> modificationWatchpointRequests() {
        return this.MODIFICATION_WATCHPOINT_TYPE.getUnmodifiableList();
    }

    @Override
    public List<StepRequest> stepRequests() {
        return this.STEP_TYPE.getUnmodifiableList();
    }

    @Override
    public List<ThreadDeathRequest> threadDeathRequests() {
        return this.THREAD_DEATH_TYPE.getUnmodifiableList();
    }

    @Override
    public List<ThreadStartRequest> threadStartRequests() {
        return this.THREAD_START_TYPE.getUnmodifiableList();
    }

    @Override
    public List<VMDeathRequest> vmDeathRequests() {
        return this.VM_DEATH_TYPE.getUnmodifiableList();
    }

    @Override
    public List<MonitorContendedEnterRequest> monitorContendedEnterRequests() {
        return this.MONITOR_CONTENDED_ENTER_TYPE.getUnmodifiableList();
    }

    @Override
    public List<MonitorContendedEnteredRequest> monitorContendedEnteredRequests() {
        return this.MONITOR_CONTENDED_ENTERED_TYPE.getUnmodifiableList();
    }

    @Override
    public List<MonitorWaitRequest> monitorWaitRequests() {
        return this.MONITOR_WAIT_TYPE.getUnmodifiableList();
    }

    @Override
    public List<MonitorWaitedRequest> monitorWaitedRequests() {
        return this.MONITOR_WAITED_TYPE.getUnmodifiableList();
    }

    public void removeRequestIDMapping(EventRequestImpl req) {
        if (req instanceof AccessWatchpointRequestImpl) {
            this.ACCESS_WATCHPOINT_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof BreakpointRequestImpl) {
            this.BREAKPOINT_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof ClassPrepareRequestImpl) {
            this.CLASS_PREPARE_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof ClassUnloadRequestImpl) {
            this.CLASS_UNLOAD_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof ExceptionRequestImpl) {
            this.EXCEPTION_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof MethodEntryRequestImpl) {
            this.METHOD_ENTRY_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof MethodExitRequestImpl) {
            this.METHOD_EXIT_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof ModificationWatchpointRequestImpl) {
            this.MODIFICATION_WATCHPOINT_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof StepRequestImpl) {
            this.STEP_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof ThreadDeathRequestImpl) {
            this.THREAD_DEATH_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof ThreadStartRequestImpl) {
            this.THREAD_START_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof MonitorContendedEnterRequestImpl) {
            this.MONITOR_CONTENDED_ENTER_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof MonitorContendedEnteredRequestImpl) {
            this.MONITOR_CONTENDED_ENTERED_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof MonitorWaitRequestImpl) {
            this.MONITOR_WAIT_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof MonitorWaitedRequestImpl) {
            this.MONITOR_WAITED_TYPE.enabledrequests.remove(req.requestID());
        } else if (req instanceof VMDeathRequestImpl) {
            this.VM_DEATH_TYPE.enabledrequests.remove(req.requestID());
        }
    }

    public void addRequestIDMapping(EventRequestImpl req) {
        if (req instanceof AccessWatchpointRequestImpl) {
            this.ACCESS_WATCHPOINT_TYPE.enabledrequests.put(req.requestID(), (AccessWatchpointRequestImpl)req);
        } else if (req instanceof BreakpointRequestImpl) {
            this.BREAKPOINT_TYPE.enabledrequests.put(req.requestID(), (BreakpointRequestImpl)req);
        } else if (req instanceof ClassPrepareRequestImpl) {
            this.CLASS_PREPARE_TYPE.enabledrequests.put(req.requestID(), (ClassPrepareRequestImpl)req);
        } else if (req instanceof ClassUnloadRequestImpl) {
            this.CLASS_UNLOAD_TYPE.enabledrequests.put(req.requestID(), (ClassUnloadRequestImpl)req);
        } else if (req instanceof ExceptionRequestImpl) {
            this.EXCEPTION_TYPE.enabledrequests.put(req.requestID(), (ExceptionRequestImpl)req);
        } else if (req instanceof MethodEntryRequestImpl) {
            this.METHOD_ENTRY_TYPE.enabledrequests.put(req.requestID(), (MethodEntryRequestImpl)req);
        } else if (req instanceof MethodExitRequestImpl) {
            this.METHOD_EXIT_TYPE.enabledrequests.put(req.requestID(), (MethodExitRequestImpl)req);
        } else if (req instanceof ModificationWatchpointRequestImpl) {
            this.MODIFICATION_WATCHPOINT_TYPE.enabledrequests.put(req.requestID(), (ModificationWatchpointRequestImpl)req);
        } else if (req instanceof StepRequestImpl) {
            this.STEP_TYPE.enabledrequests.put(req.requestID(), (StepRequestImpl)req);
        } else if (req instanceof ThreadDeathRequestImpl) {
            this.THREAD_DEATH_TYPE.enabledrequests.put(req.requestID(), (ThreadDeathRequestImpl)req);
        } else if (req instanceof ThreadStartRequestImpl) {
            this.THREAD_START_TYPE.enabledrequests.put(req.requestID(), (ThreadStartRequestImpl)req);
        } else if (req instanceof MonitorWaitRequestImpl) {
            this.MONITOR_WAIT_TYPE.enabledrequests.put(req.requestID(), (MonitorWaitRequestImpl)req);
        } else if (req instanceof MonitorWaitedRequestImpl) {
            this.MONITOR_WAITED_TYPE.enabledrequests.put(req.requestID(), (MonitorWaitedRequestImpl)req);
        } else if (req instanceof MonitorContendedEnterRequestImpl) {
            this.MONITOR_CONTENDED_ENTER_TYPE.enabledrequests.put(req.requestID(), (MonitorContendedEnterRequestImpl)req);
        } else if (req instanceof MonitorContendedEnteredRequestImpl) {
            this.MONITOR_CONTENDED_ENTERED_TYPE.enabledrequests.put(req.requestID(), (MonitorContendedEnteredRequestImpl)req);
        } else if (req instanceof VMDeathRequestImpl) {
            this.VM_DEATH_TYPE.enabledrequests.put(req.requestID(), (VMDeathRequest)((Object)req));
        }
    }

    public EventRequest findRequest(EventImpl event) {
        if (event instanceof AccessWatchpointEventImpl) {
            return (EventRequest)this.ACCESS_WATCHPOINT_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof BreakpointEventImpl) {
            return (EventRequest)this.BREAKPOINT_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof ClassPrepareEventImpl) {
            return (EventRequest)this.CLASS_PREPARE_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof ClassUnloadEventImpl) {
            return (EventRequest)this.CLASS_UNLOAD_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof ExceptionEventImpl) {
            return (EventRequest)this.EXCEPTION_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof MethodEntryEventImpl) {
            return (EventRequest)this.METHOD_ENTRY_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof MethodExitEventImpl) {
            return (EventRequest)this.METHOD_EXIT_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof ModificationWatchpointEventImpl) {
            return (EventRequest)this.MODIFICATION_WATCHPOINT_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof StepEventImpl) {
            return (EventRequest)this.STEP_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof ThreadDeathEventImpl) {
            return (EventRequest)this.THREAD_DEATH_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof ThreadStartEventImpl) {
            return (EventRequest)this.THREAD_START_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof VMDeathEventImpl) {
            return (EventRequest)this.VM_DEATH_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof MonitorWaitEventImpl) {
            return (EventRequest)this.MONITOR_WAIT_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof MonitorWaitedEventImpl) {
            return (EventRequest)this.MONITOR_WAITED_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof MonitorContendedEnterEventImpl) {
            return (EventRequest)this.MONITOR_CONTENDED_ENTER_TYPE.enabledrequests.get(event.requestID());
        }
        if (event instanceof MonitorContendedEnteredEventImpl) {
            return (EventRequest)this.MONITOR_CONTENDED_ENTERED_TYPE.enabledrequests.get(event.requestID());
        }
        throw new InternalError(RequestMessages.EventRequestManagerImpl_Got_event_of_unknown_type_2);
    }

    private static class EventRequestType<RT extends EventRequest> {
        private ArrayList<RT> requests = new ArrayList();
        private Hashtable<RequestID, RT> enabledrequests = new Hashtable();

        private EventRequestType() {
        }

        public List<RT> getUnmodifiableList() {
            return Collections.unmodifiableList(this.requests);
        }

        public void clear() {
            this.requests.clear();
            this.enabledrequests.clear();
        }
    }
}

