/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaIT;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.api.ldap.model.message.controls.Subentries;
import org.apache.directory.api.ldap.model.message.controls.SubentriesImpl;

public class Controls {
    public static final Subentries SUBENTRIES_CONTROL = new SubentriesImpl();
    public static final ManageDsaIT MANAGEDSAIT_CONTROL;
    public static final Control TREEDELETE_CONTROL;

    static {
        SUBENTRIES_CONTROL.setVisibility(true);
        MANAGEDSAIT_CONTROL = new ManageDsaITImpl();
        TREEDELETE_CONTROL = new OpaqueControl("1.2.840.113556.1.4.805", false);
    }

    public static final PagedResults newPagedResultsControl(int size) {
        PagedResultsImpl control = new PagedResultsImpl();
        control.setSize(size);
        return control;
    }

    public static final PagedResults newPagedResultsControl(int size, byte[] cookie) {
        PagedResultsImpl control = new PagedResultsImpl();
        control.setSize(size);
        control.setCookie(cookie);
        return control;
    }

    public static Control create(String oid, boolean isCritical, byte[] value) {
        try {
            LdapApiService codec = LdapApiServiceFactory.getSingleton();
            ControlFactory factory = (ControlFactory)codec.getRequestControlFactories().get(oid);
            Control control = factory.newControl();
            control.setCritical(isCritical);
            factory.decodeValue(control, value);
            return control;
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getEncodedValue(Control control) {
        LdapApiService codec = LdapApiServiceFactory.getSingleton();
        ControlFactory factory = (ControlFactory)codec.getRequestControlFactories().get(control.getOid());
        Asn1Buffer buffer = new Asn1Buffer();
        factory.encodeValue(buffer, control);
        byte[] bytes = buffer.getBytes().array();
        return bytes;
    }
}

