/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.views;

import org.apache.directory.studio.ldapservers.LdapServersPlugin;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.apache.directory.studio.ldapservers.views.Messages;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ServersViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String ONE_DOT = ".";
    private int dotsCount = 1;

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof LdapServer) {
            LdapServer server = (LdapServer)element;
            if (columnIndex == 0) {
                return server.getName();
            }
            if (columnIndex == 1) {
                LdapServerStatus status = ((LdapServer)element).getStatus();
                switch (status) {
                    case STARTED: {
                        return Messages.getString("ServersViewLabelProvider.Started");
                    }
                    case STARTING: {
                        return String.valueOf(Messages.getString("ServersViewLabelProvider.Starting")) + this.getDots();
                    }
                    case STOPPED: {
                        return Messages.getString("ServersViewLabelProvider.Stopped");
                    }
                    case STOPPING: {
                        return String.valueOf(Messages.getString("ServersViewLabelProvider.Stopping")) + this.getDots();
                    }
                    case UNKNOWN: {
                        return Messages.getString("ServersViewLabelProvider.Unknown");
                    }
                    case REPAIRING: {
                        return String.valueOf(Messages.getString("ServersViewLabelProvider.Repairing")) + this.getDots();
                    }
                }
            }
        }
        return super.getText(element);
    }

    private String getDots() {
        if (this.dotsCount == 1) {
            return ONE_DOT;
        }
        if (this.dotsCount == 2) {
            return TWO_DOTS;
        }
        return THREE_DOTS;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof LdapServer) {
            if (columnIndex == 0) {
                return LdapServersPlugin.getDefault().getImage("resources/icons/server.gif");
            }
            if (columnIndex == 1) {
                switch (((LdapServer)element).getStatus()) {
                    case STARTED: {
                        return LdapServersPlugin.getDefault().getImage("resources/icons/server_started.gif");
                    }
                    case STARTING: 
                    case REPAIRING: {
                        switch (this.dotsCount) {
                            case 1: {
                                return LdapServersPlugin.getDefault().getImage("resources/icons/server_starting1.gif");
                            }
                            case 2: {
                                return LdapServersPlugin.getDefault().getImage("resources/icons/server_starting2.gif");
                            }
                            case 3: {
                                return LdapServersPlugin.getDefault().getImage("resources/icons/server_starting3.gif");
                            }
                        }
                    }
                    case STOPPED: {
                        return LdapServersPlugin.getDefault().getImage("resources/icons/server_stopped.gif");
                    }
                    case STOPPING: {
                        switch (this.dotsCount) {
                            case 1: {
                                return LdapServersPlugin.getDefault().getImage("resources/icons/server_stopping1.gif");
                            }
                            case 2: {
                                return LdapServersPlugin.getDefault().getImage("resources/icons/server_stopping2.gif");
                            }
                            case 3: {
                                return LdapServersPlugin.getDefault().getImage("resources/icons/server_stopping3.gif");
                            }
                        }
                    }
                    case UNKNOWN: {
                        return LdapServersPlugin.getDefault().getImage("resources/icons/server.gif");
                    }
                }
            }
        }
        return super.getImage(element);
    }

    public void animate() {
        ++this.dotsCount;
        if (this.dotsCount > 3) {
            this.dotsCount = 1;
        }
    }
}

