/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.aciitemeditor.widgets;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.studio.aciitemeditor.ACIItemValueWithContext;
import org.apache.directory.studio.aciitemeditor.Activator;
import org.apache.directory.studio.aciitemeditor.dialogs.MultiValuedDialog;
import org.apache.directory.studio.aciitemeditor.model.UserClassWrapper;
import org.apache.directory.studio.aciitemeditor.model.UserClassWrapperFactory;
import org.apache.directory.studio.aciitemeditor.widgets.Messages;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class ACIItemUserClassesComposite
extends Composite {
    private ACIItemValueWithContext context;
    private Composite composite = null;
    private CheckboxTableViewer tableViewer = null;
    private Button editButton = null;
    private UserClassWrapper[] userClassWrappers = UserClassWrapperFactory.createUserClassWrappers();

    public ACIItemUserClassesComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.verticalAlignment = 2;
        this.setLayoutData(layoutData);
        this.createComposite();
    }

    private void createComposite() {
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 2;
        labelGridData.verticalAlignment = 2;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayoutData((Object)gridData);
        this.composite.setLayout((Layout)gridLayout);
        Label label = new Label(this.composite, 0);
        label.setText(Messages.getString("ACIItemUserClassesComposite.description"));
        label.setLayoutData((Object)labelGridData);
        this.createTable();
        this.createButtonComposite();
    }

    private void createTable() {
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.verticalAlignment = 4;
        tableGridData.horizontalAlignment = 4;
        Table table = new Table(this.composite, 2080);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)tableGridData);
        table.setLinesVisible(false);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new UserClassesLabelProvider());
        this.tableViewer.setInput((Object)this.userClassWrappers);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ACIItemUserClassesComposite.this.userClassSelected();
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ACIItemUserClassesComposite.this.userClassChecked();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ACIItemUserClassesComposite.this.editButton.isEnabled()) {
                    ACIItemUserClassesComposite.this.editUserClass();
                }
            }
        });
    }

    private void createButtonComposite() {
        GridData reverseSelectionButtonGridData = new GridData();
        reverseSelectionButtonGridData.horizontalAlignment = 4;
        reverseSelectionButtonGridData.grabExcessHorizontalSpace = false;
        reverseSelectionButtonGridData.verticalAlignment = 1;
        reverseSelectionButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData deselectAllButtonGridData = new GridData();
        deselectAllButtonGridData.horizontalAlignment = 4;
        deselectAllButtonGridData.grabExcessHorizontalSpace = false;
        deselectAllButtonGridData.verticalAlignment = 1;
        deselectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData selectAllButtonGridData = new GridData();
        selectAllButtonGridData.horizontalAlignment = 4;
        selectAllButtonGridData.grabExcessHorizontalSpace = false;
        selectAllButtonGridData.verticalAlignment = 1;
        selectAllButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridData editButtonGridData = new GridData();
        editButtonGridData.horizontalAlignment = 4;
        editButtonGridData.grabExcessHorizontalSpace = false;
        editButtonGridData.verticalAlignment = 1;
        editButtonGridData.widthHint = Activator.getButtonWidth((Control)this);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        Composite buttonComposite = new Composite(this.composite, 0);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)gridLayout);
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setText(Messages.getString("ACIItemUserClassesComposite.edit.button"));
        this.editButton.setLayoutData((Object)editButtonGridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemUserClassesComposite.this.editUserClass();
            }
        });
        this.editButton.setEnabled(false);
        Button selectAllButton = new Button(buttonComposite, 0);
        selectAllButton.setText(Messages.getString("ACIItemUserClassesComposite.selectAll.button"));
        selectAllButton.setLayoutData((Object)selectAllButtonGridData);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemUserClassesComposite.this.tableViewer.setCheckedElements((Object[])ACIItemUserClassesComposite.this.userClassWrappers);
                ACIItemUserClassesComposite.this.refreshTable();
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 0);
        deselectAllButton.setText(Messages.getString("ACIItemUserClassesComposite.deselectAll.button"));
        deselectAllButton.setLayoutData((Object)deselectAllButtonGridData);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ACIItemUserClassesComposite.this.tableViewer.setCheckedElements((Object[])new ProtectedItem[0]);
                ACIItemUserClassesComposite.this.refreshTable();
            }
        });
        Button reverseSelectionButton = new Button(buttonComposite, 0);
        reverseSelectionButton.setText(Messages.getString("ACIItemUserClassesComposite.revert.buton"));
        reverseSelectionButton.setLayoutData((Object)reverseSelectionButtonGridData);
        reverseSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ArrayList<UserClassWrapper> elements = new ArrayList<UserClassWrapper>();
                elements.addAll(Arrays.asList(ACIItemUserClassesComposite.this.userClassWrappers));
                elements.removeAll(Arrays.asList(ACIItemUserClassesComposite.this.tableViewer.getCheckedElements()));
                ACIItemUserClassesComposite.this.tableViewer.setCheckedElements(elements.toArray());
                ACIItemUserClassesComposite.this.refreshTable();
            }
        });
    }

    public void setContext(ACIItemValueWithContext context) {
        this.context = context;
    }

    public void setUserClasses(Collection<UserClass> userClasses) {
        UserClassWrapper[] userClassWrapperArray = this.userClassWrappers;
        int n = this.userClassWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            UserClassWrapper userClassWrapper = userClassWrapperArray[n2];
            this.tableViewer.setChecked((Object)userClassWrapper, false);
            ++n2;
        }
        for (UserClass userClass : userClasses) {
            UserClassWrapper[] userClassWrapperArray2 = this.userClassWrappers;
            int n3 = this.userClassWrappers.length;
            int n4 = 0;
            while (n4 < n3) {
                UserClassWrapper userClassWrapper = userClassWrapperArray2[n4];
                if (userClassWrapper.getClazz() == userClass.getClass()) {
                    userClassWrapper.setUserClass(userClass);
                    this.tableViewer.setChecked((Object)userClassWrapper, true);
                }
                ++n4;
            }
        }
        this.refreshTable();
    }

    public Collection<UserClass> getUserClasses() throws ParseException {
        ArrayList<UserClass> userClasses = new ArrayList<UserClass>();
        UserClassWrapper[] userClassWrapperArray = this.userClassWrappers;
        int n = this.userClassWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            UserClassWrapper userClassWrapper = userClassWrapperArray[n2];
            if (this.tableViewer.getChecked((Object)userClassWrapper)) {
                UserClass userClass = userClassWrapper.getUserClass();
                userClasses.add(userClass);
            }
            ++n2;
        }
        return userClasses;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
    }

    private UserClassWrapper getSelectedUserClassWrapper() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof UserClassWrapper) {
            return (UserClassWrapper)element;
        }
        return null;
    }

    private void userClassSelected() {
        UserClassWrapper userClassWrapper = this.getSelectedUserClassWrapper();
        if (userClassWrapper == null || !userClassWrapper.isEditable()) {
            this.editButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
        }
    }

    private void userClassChecked() {
        this.refreshTable();
    }

    private void editUserClass() {
        UserClassWrapper userClassWrapper = this.getSelectedUserClassWrapper();
        AbstractDialogStringValueEditor editor = userClassWrapper.getValueEditor();
        if (editor != null) {
            MultiValuedDialog dialog = new MultiValuedDialog(this.getShell(), userClassWrapper.getDisplayName(), userClassWrapper.getValues(), this.context, editor);
            dialog.open();
            this.refreshTable();
        }
    }

    private void refreshTable() {
        this.tableViewer.refresh();
    }

    private class UserClassesLabelProvider
    extends LabelProvider {
        private UserClassesLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof UserClassWrapper) {
                UserClassWrapper wrapper = (UserClassWrapper)element;
                if (ACIItemUserClassesComposite.this.tableViewer.getChecked((Object)wrapper)) {
                    try {
                        wrapper.getUserClass();
                    }
                    catch (ParseException parseException) {
                        return Activator.getDefault().getImage(Messages.getString("ACIItemUserClassesComposite.error.icon"));
                    }
                }
            }
            return null;
        }
    }
}

