/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.QuickSearch;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class OpenQuickSearchAction
extends BrowserAction {
    @Override
    public void run() {
        IBrowserConnection browserConnection = this.getBrowserConnection();
        if (browserConnection != null) {
            IQuickSearch quickSearch = browserConnection.getQuickSearch();
            if (quickSearch == null || !this.isQuickSearchSelected()) {
                IRootDSE searchBase = browserConnection.getRootDSE();
                IEntry selectedEntry = this.getSelectedEntry();
                if (selectedEntry != null) {
                    searchBase = selectedEntry;
                }
                quickSearch = new QuickSearch((IEntry)searchBase, browserConnection);
                browserConnection.setQuickSearch(quickSearch);
            }
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)quickSearch, (String)"org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.SearchPropertyPage", null, null);
            dialog.getShell().setText(NLS.bind((String)Messages.getString("PropertiesAction.PropertiesForX"), (Object)Utils.shorten((String)quickSearch.getName(), (int)30)));
            if (dialog.open() == 0 && quickSearch.getSearchResults() == null) {
                new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new SearchRunnable(new ISearch[]{quickSearch})}).execute();
            }
        }
    }

    @Override
    public String getText() {
        return Messages.getString("OpenQuickSearchAction.OpenQuickSearch");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/quicksearch.gif");
    }

    @Override
    public String getCommandId() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.getBrowserConnection() != null;
    }

    private IBrowserConnection getBrowserConnection() {
        if (this.getInput() instanceof IBrowserConnection) {
            return (IBrowserConnection)this.getInput();
        }
        if (this.getSelectedSearchResults().length > 0) {
            return this.getSelectedSearchResults()[0].getEntry().getBrowserConnection();
        }
        if (this.getSelectedEntries().length > 0) {
            return this.getSelectedEntries()[0].getBrowserConnection();
        }
        if (this.getSelectedSearches().length > 0) {
            return this.getSelectedSearches()[0].getBrowserConnection();
        }
        return null;
    }

    private IEntry getSelectedEntry() {
        if (this.getSelectedEntries().length == 1) {
            return this.getSelectedEntries()[0];
        }
        return null;
    }

    private boolean isQuickSearchSelected() {
        if (this.getSelectedSearches().length == 1) {
            return this.getSelectedSearches()[0] instanceof IQuickSearch;
        }
        return false;
    }
}

