/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import org.apache.directory.studio.ldapbrowser.core.model.IValue;

public class LdapFilterUtils {
    public static String getFilter(IValue value) {
        if (value.isString()) {
            return "(" + value.getAttribute().getDescription() + "=" + LdapFilterUtils.getEncodedValue(value.getStringValue()) + ")";
        }
        StringBuffer filter = new StringBuffer();
        filter.append("(");
        filter.append(value.getAttribute().getDescription());
        filter.append("=");
        byte[] bytes = value.getBinaryValue();
        int i = 0;
        while (i < bytes.length) {
            int b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            String s = Integer.toHexString(b);
            filter.append("\\");
            if (s.length() == 1) {
                filter.append("0");
            }
            filter.append(s);
            ++i;
        }
        filter.append(")");
        return filter.toString();
    }

    public static String getEncodedValue(String value) {
        value = value.replaceAll("\\\\", "\\\\5c");
        value = value.replaceAll("\u0000", "\\\\00");
        value = value.replaceAll("\\*", "\\\\2a");
        value = value.replaceAll("\\(", "\\\\28");
        value = value.replaceAll("\\)", "\\\\29");
        return value;
    }
}

