/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureCounts;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.RankedFeatureVector;

public class PerLabelFeatureCounts {
    Alphabet dataAlphabet;
    Alphabet targetAlphabet;
    FeatureCounts[] fc;
    static boolean countInstances = true;

    private static double[][] calcFeatureCounts(InstanceList ilist) {
        int numClasses = ilist.getTargetAlphabet().size();
        int numFeatures = ilist.getDataAlphabet().size();
        double[][] featureCounts = new double[numClasses][numFeatures];
        for (int i = 0; i < ilist.size(); ++i) {
            Instance inst = (Instance)ilist.get(i);
            if (!(inst.getData() instanceof FeatureVector)) {
                throw new IllegalArgumentException("Currently only handles FeatureVector data");
            }
            FeatureVector fv = (FeatureVector)inst.getData();
            int labelIndex = inst.getLabeling().getBestIndex();
            for (int fl = 0; fl < fv.numLocations(); ++fl) {
                int fli = fv.indexAtLocation(fl);
                if (countInstances) {
                    double[] dArray = featureCounts[labelIndex];
                    int n = fli;
                    dArray[n] = dArray[n] + 1.0;
                    continue;
                }
                double[] dArray = featureCounts[labelIndex];
                int n = fli;
                dArray[n] = dArray[n] + fv.valueAtLocation(fl);
            }
        }
        return featureCounts;
    }

    public PerLabelFeatureCounts(InstanceList ilist) {
        this.dataAlphabet = ilist.getDataAlphabet();
        this.targetAlphabet = ilist.getTargetAlphabet();
        double[][] counts = PerLabelFeatureCounts.calcFeatureCounts(ilist);
        this.fc = new FeatureCounts[this.targetAlphabet.size()];
        for (int i = 0; i < this.fc.length; ++i) {
            this.fc[i] = new FeatureCounts(this.dataAlphabet, counts[i]);
        }
    }

    public static class Factory
    implements RankedFeatureVector.PerLabelFactory {
        public RankedFeatureVector[] newRankedFeatureVectors(InstanceList ilist) {
            PerLabelFeatureCounts x = new PerLabelFeatureCounts(ilist);
            return x.fc;
        }
    }
}

