/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SegmentationEvaluator
extends TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(SegmentationEvaluator.class.getName());
    static Pattern startRegex = Pattern.compile("^B.*");
    Object segmentStartTag = new Object(){

        public boolean equals(Object o) {
            return startRegex.matcher(o.toString()).matches();
        }
    };
    Object segmentEndTag = new Object(){

        public boolean equals(Object o) {
            return false;
        }
    };

    public SegmentationEvaluator(InstanceList[] instanceLists, String[] descriptions) {
        super(instanceLists, descriptions);
    }

    public SegmentationEvaluator(InstanceList instanceList1, String description1) {
        this(new InstanceList[]{instanceList1}, new String[]{description1});
    }

    public SegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2) {
        this(new InstanceList[]{instanceList1, instanceList2}, new String[]{description1, description2});
    }

    public SegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, InstanceList instanceList3, String description3) {
        this(new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{description1, description2, description3});
    }

    public SegmentationEvaluator setSegmentStartTag(Object o) {
        this.segmentStartTag = o;
        return this;
    }

    public SegmentationEvaluator setSegmentEndTag(Object o) {
        this.segmentEndTag = o;
        return this;
    }

    public void evaluateInstanceList(TransducerTrainer tt, InstanceList data, String description) {
        Transducer model = tt.getTransducer();
        Object sourceTokenSequence = null;
        int numCorrectTokens = 0;
        int totalTokens = 0;
        int numCorrectSegments = 0;
        int numPredictedSegments = 0;
        int numTrueSegments = 0;
        boolean numCorrectSegmentsOOV = false;
        boolean numCorrectSegmentsInAlphabet = false;
        boolean numIncorrectSegmentsOOV = false;
        boolean numIncorrectSegmentsInAlphabet = false;
        for (int i = 0; i < data.size(); ++i) {
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = model.transduce(input);
            assert (predOutput.size() == trueOutput.size());
            for (int j = 0; j < trueOutput.size(); ++j) {
                ++totalTokens;
                boolean predStart = false;
                boolean trueStart = false;
                if (this.segmentStartTag.equals(trueOutput.get(j))) {
                    ++numTrueSegments;
                    trueStart = true;
                }
                if (this.segmentStartTag.equals(predOutput.get(j))) {
                    predStart = true;
                    ++numPredictedSegments;
                }
                if (trueStart && predStart) {
                    int m;
                    for (m = j + 1; m < trueOutput.size(); ++m) {
                        predStart = false;
                        trueStart = false;
                        if (this.segmentEndTag.equals(trueOutput.get(m))) {
                            trueStart = true;
                        }
                        if (this.segmentEndTag.equals(predOutput.get(m))) {
                            predStart = true;
                        }
                        if (!trueStart && !predStart) continue;
                        if (!trueStart || !predStart) break;
                        ++numCorrectSegments;
                        break;
                    }
                    if (m == trueOutput.size() && trueStart == predStart) {
                        ++numCorrectSegments;
                    }
                } else if (predStart) {
                    // empty if block
                }
                if (!trueOutput.get(j).equals(predOutput.get(j))) continue;
                ++numCorrectTokens;
            }
        }
        logger.info(description + " accuracy=" + (double)numCorrectTokens / (double)totalTokens);
        double precision = numPredictedSegments == 0 ? 1.0 : (double)numCorrectSegments / (double)numPredictedSegments;
        double recall = numTrueSegments == 0 ? 1.0 : (double)numCorrectSegments / (double)numTrueSegments;
        double f1 = recall + precision == 0.0 ? 0.0 : 2.0 * recall * precision / (recall + precision);
        logger.info(" precision=" + precision + " recall=" + recall + " f1=" + f1);
        logger.info("segments true=" + numTrueSegments + " pred=" + numPredictedSegments + " correct=" + numCorrectSegments + " misses=" + (numTrueSegments - numCorrectSegments) + " alarms=" + (numPredictedSegments - numCorrectSegments));
    }
}

