/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.inference.Utils;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.Universe;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;

public class ListVarSet
extends AbstractSet
implements VarSet,
Serializable {
    private transient Universe universe;
    private transient TIntArrayList included;
    private int cachedWeight = -1;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public ListVarSet(Universe universe, Collection included) {
        this.universe = universe;
        this.included = new TIntArrayList(included.size());
        java.util.Iterator it = included.iterator();
        while (it.hasNext()) {
            this.included.add(universe.getIndex((Variable)it.next()));
        }
        this.included.sort();
    }

    public ListVarSet(VarSet vsOld) {
        this(vsOld.get(0).getUniverse(), vsOld);
    }

    public boolean add(Object o) {
        int idx = this.universe.getIndex((Variable)o);
        if (idx == -1) {
            throw new UnsupportedOperationException();
        }
        this.included.add(idx);
        this.included.sort();
        return true;
    }

    public Variable get(int idx) {
        int gidx = this.included.get(idx);
        return this.universe.get(gidx);
    }

    public Variable[] toVariableArray() {
        return this.toArray(new Variable[0]);
    }

    public int weight() {
        if (this.cachedWeight == -1) {
            int weight = 1;
            Iterator it = new Iterator();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                weight *= var.getNumOutcomes();
            }
            this.cachedWeight = weight;
        }
        return this.cachedWeight;
    }

    public AssignmentIterator assignmentIterator() {
        return new DenseAssignmentIterator(this);
    }

    public int size() {
        return this.included.size();
    }

    public boolean isEmpty() {
        return this.included.isEmpty();
    }

    public boolean contains(Object o) {
        return this.included.contains(this.universe.getIndex((Variable)o));
    }

    public java.util.Iterator iterator() {
        return new Iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VarSet)) {
            return false;
        }
        VarSet vs = (VarSet)o;
        return vs.size() == this.size() && this.containsAll(vs);
    }

    public int hashCode() {
        int result = 39;
        for (int vi = 0; vi < this.size(); ++vi) {
            result = 59 * result + this.get(vi).hashCode();
        }
        return result;
    }

    public VarSet intersection(VarSet c) {
        return Utils.defaultIntersection(this, c);
    }

    public void clear() {
        this.included.clear();
    }

    public String toString() {
        String foo = "(C";
        Iterator it = new Iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            foo = foo + " " + var;
        }
        foo = foo + ")";
        return foo;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
        out.writeObject(this.universe);
        out.writeObject(this.included.toNativeArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
        this.universe = (Universe)in.readObject();
        int[] vals = (int[])in.readObject();
        this.included = new TIntArrayList(vals);
    }

    private class Iterator
    implements java.util.Iterator {
        int nextIdx = 0;

        public boolean hasNext() {
            return this.nextIdx < ListVarSet.this.included.size();
        }

        public Object next() {
            int thisIdx = this.nextIdx++;
            return ListVarSet.this.universe.get(ListVarSet.this.included.get(thisIdx));
        }

        public void remove() {
            throw new UnsupportedOperationException("Removal from BitSetClique not permitted");
        }
    }
}

