/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.search;

import cc.mallet.util.MalletLogger;
import cc.mallet.util.search.AStarNode;
import cc.mallet.util.search.AStarState;
import cc.mallet.util.search.MinHeap;
import cc.mallet.util.search.PriorityQueue;
import cc.mallet.util.search.SearchNode;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AStar
implements Iterator<AStarNode> {
    private static Logger logger = MalletLogger.getLogger(AStar.class.getName());
    private PriorityQueue q;
    private AStarNode answer;
    private boolean needNext;

    public AStar(AStarState[] initial, int expectedSize) {
        this.q = new MinHeap(expectedSize);
        for (int i = 0; i < initial.length; ++i) {
            AStarState s = initial[i];
            AStarNode n = new AStarNode(s, null, 0.0);
            n.setPriority(s.completionCost());
            this.q.insert(n);
        }
        this.needNext = true;
    }

    private void lookAhead() {
        if (this.needNext) {
            this.answer = this.search();
            this.needNext = false;
        }
    }

    @Override
    public boolean hasNext() {
        this.lookAhead();
        return this.answer != null;
    }

    @Override
    public AStarNode next() {
        return this.nextAnswer();
    }

    public AStarNode nextAnswer() {
        this.lookAhead();
        this.needNext = true;
        return this.answer;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private AStarNode search() {
        while (this.q.size() > 0) {
            AStarNode u = (AStarNode)this.q.extractMin();
            if (u.isFinal()) {
                return u;
            }
            SearchNode.NextNodeIterator i = u.getNextNodes();
            while (i.hasNext()) {
                AStarNode v = (AStarNode)i.nextNode();
                double priority = v.getCost() + v.completionCost();
                v.setPriority(priority);
                this.q.insert(v);
            }
        }
        return null;
    }
}

