/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DiscreteFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;
import java.util.Collection;

public class CPT
implements DiscreteFactor {
    private DiscreteFactor subFactor;
    private VarSet parents;
    private Variable child;

    public CPT(DiscreteFactor subFactor, Variable child) {
        this.subFactor = subFactor;
        this.child = child;
        if (!subFactor.containsVar(child)) {
            throw new IllegalArgumentException("Invalid child var for CPT\n  Child: " + child + "\n  Factor: " + subFactor);
        }
        this.parents = new HashVarSet(subFactor.varSet());
        this.parents.remove(child);
    }

    public VarSet getParents() {
        return this.parents;
    }

    public Variable getChild() {
        return this.child;
    }

    public void setSubFactor(DiscreteFactor subFactor) {
        this.subFactor = subFactor;
    }

    public String toString() {
        return "CPT: Child [" + this.child + "]\n  Factor: " + this.subFactor.toString();
    }

    public double value(Assignment assn) {
        return this.subFactor.value(assn);
    }

    public double value(AssignmentIterator it) {
        return this.subFactor.value(it);
    }

    public Factor normalize() {
        return this.subFactor.normalize();
    }

    public Factor marginalize(Variable[] vars) {
        return this.subFactor.marginalize(vars);
    }

    public Factor marginalize(Collection vars) {
        return this.subFactor.marginalize(vars);
    }

    public Factor marginalize(Variable var) {
        return this.subFactor.marginalize(var);
    }

    public Factor marginalizeOut(Variable var) {
        return this.subFactor.marginalizeOut(var);
    }

    public Factor extractMax(Collection vars) {
        return this.subFactor.extractMax(vars);
    }

    public Factor extractMax(Variable var) {
        return this.subFactor.extractMax(var);
    }

    public Factor extractMax(Variable[] vars) {
        return this.subFactor.extractMax(vars);
    }

    public int argmax() {
        return this.subFactor.argmax();
    }

    public Assignment sample(Randoms r) {
        return this.subFactor.sample(r);
    }

    public double sum() {
        return this.subFactor.sum();
    }

    public double entropy() {
        return this.subFactor.entropy();
    }

    public Factor multiply(Factor dist) {
        return this.subFactor.multiply(dist);
    }

    public void multiplyBy(Factor pot) {
        this.subFactor.multiplyBy(pot);
    }

    public void exponentiate(double power) {
        this.subFactor.exponentiate(power);
    }

    public void divideBy(Factor pot) {
        this.subFactor.divideBy(pot);
    }

    public boolean containsVar(Variable var) {
        return this.subFactor.containsVar(var);
    }

    public VarSet varSet() {
        return this.subFactor.varSet();
    }

    public AssignmentIterator assignmentIterator() {
        return this.subFactor.assignmentIterator();
    }

    public boolean almostEquals(Factor p) {
        return this.subFactor.almostEquals(p);
    }

    public boolean almostEquals(Factor p, double epsilon) {
        return this.subFactor.almostEquals(p, epsilon);
    }

    public Factor duplicate() {
        return this.subFactor.duplicate();
    }

    public boolean isNaN() {
        return this.subFactor.isNaN();
    }

    public double logValue(AssignmentIterator it) {
        return this.subFactor.logValue(it);
    }

    public double logValue(Assignment assn) {
        return this.subFactor.logValue(assn);
    }

    public double logValue(int loc) {
        return this.subFactor.logValue(loc);
    }

    public Variable getVariable(int i) {
        return this.subFactor.getVariable(i);
    }

    public int sampleLocation(Randoms r) {
        return this.subFactor.sampleLocation(r);
    }

    public double value(int index) {
        return this.subFactor.value(index);
    }

    public int numLocations() {
        return this.subFactor.numLocations();
    }

    public double valueAtLocation(int loc) {
        return this.subFactor.valueAtLocation(loc);
    }

    public int indexAtLocation(int loc) {
        return this.subFactor.indexAtLocation(loc);
    }

    public double[] toValueArray() {
        return this.subFactor.toValueArray();
    }

    public int singleIndex(int[] smallDims) {
        return this.subFactor.singleIndex(smallDims);
    }

    public String dumpToString() {
        return this.subFactor.dumpToString();
    }

    public Factor slice(Assignment assn) {
        return this.subFactor.slice(assn);
    }

    public AbstractTableFactor asTable() {
        return this.subFactor.asTable();
    }

    public Factor marginalizeOut(VarSet varset) {
        return this.subFactor.marginalizeOut(varset);
    }
}

