/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.iterator;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.iterator.NeighborIterator;
import cc.mallet.cluster.neighbor_evaluator.AgglomerativeNeighbor;
import cc.mallet.cluster.util.ClusterUtils;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.Randoms;

public class PairSampleIterator
extends NeighborIterator {
    protected InstanceList instances;
    protected Randoms random;
    protected double positiveProportion;
    protected int numberSamples;
    protected int positiveTarget;
    protected int positiveCount;
    protected int totalCount;
    protected int[] nonsingletonClusters;

    public PairSampleIterator(Clustering clustering, Randoms random, double positiveProportion, int numberSamples) {
        super(clustering);
        this.random = random;
        this.positiveProportion = positiveProportion;
        this.numberSamples = numberSamples;
        this.positiveTarget = (int)((double)numberSamples * positiveProportion);
        this.positiveCount = 0;
        this.totalCount = 0;
        this.instances = clustering.getInstances();
        this.setNonSingletons();
    }

    private void setNonSingletons() {
        int i;
        int c = 0;
        for (i = 0; i < this.clustering.getNumClusters(); ++i) {
            if (this.clustering.size(i) <= 1) continue;
            ++c;
        }
        this.nonsingletonClusters = new int[c];
        c = 0;
        for (i = 0; i < this.clustering.getNumClusters(); ++i) {
            if (this.clustering.size(i) <= 1) continue;
            this.nonsingletonClusters[c++] = i;
        }
    }

    public boolean hasNext() {
        return this.totalCount < this.numberSamples;
    }

    public Instance next() {
        AgglomerativeNeighbor neighbor = null;
        if (this.nonsingletonClusters.length > 0 && (this.positiveCount < this.positiveTarget || this.clustering.getNumClusters() == 1)) {
            ++this.positiveCount;
            int label = this.nonsingletonClusters[this.random.nextInt(this.nonsingletonClusters.length)];
            int[] instances = this.clustering.getIndicesWithLabel(label);
            int ii = instances[this.random.nextInt(instances.length)];
            int ij = instances[this.random.nextInt(instances.length)];
            while (ii == ij) {
                ij = instances[this.random.nextInt(instances.length)];
            }
            neighbor = new AgglomerativeNeighbor(this.clustering, this.clustering, ii, ij);
        } else {
            int ii = this.random.nextInt(this.instances.size());
            int ij = this.random.nextInt(this.instances.size());
            while (this.clustering.getLabel(ii) == this.clustering.getLabel(ij)) {
                ij = this.random.nextInt(this.instances.size());
            }
            neighbor = new AgglomerativeNeighbor(this.clustering, ClusterUtils.copyAndMergeInstances(this.clustering, ii, ij), ii, ij);
        }
        ++this.totalCount;
        return new Instance(neighbor, null, null, null);
    }
}

