/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf.tests;

import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintInput;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.TokenSequenceLowercase;
import cc.mallet.pipe.tsf.OffsetConjunctions;
import cc.mallet.pipe.tsf.RegexMatches;
import cc.mallet.pipe.tsf.TokenText;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOffsetConjunctions
extends TestCase {
    public TestOffsetConjunctions(String name) {
        super(name);
    }

    public void testOne() {
        String input = "abcdefghijklmnopqrstuvwxyz";
        SerialPipes p = new SerialPipes(new Pipe[]{new CharSequence2TokenSequence("."), new TokenSequenceLowercase(), new TokenText(), new RegexMatches("V", Pattern.compile("[aeiou]")), new OffsetConjunctions(new int[][]{{0, 0}, {0, 1}, {-1, 0, 1}, {-1}, {-2}}), new PrintInput("5:")});
        Instance carrier = p.instanceFrom(new Instance(input, null, null, null));
        TokenSequence ts = (TokenSequence)carrier.getData();
        TestOffsetConjunctions.assertTrue((ts.size() == 26 ? 1 : 0) != 0);
        TestOffsetConjunctions.assertTrue((((Token)ts.get(0)).getFeatureValue("a_&_b@1") == 1.0 ? 1 : 0) != 0);
        TestOffsetConjunctions.assertTrue((((Token)ts.get(0)).getFeatureValue("V_&_a") == 1.0 ? 1 : 0) != 0);
        TestOffsetConjunctions.assertTrue((((Token)ts.get(2)).getFeatureValue("b@-1_&_c_&_d@1") == 1.0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new TestSuite(TestOffsetConjunctions.class);
    }

    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOffsetConjunctions.suite());
    }
}

