/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;
import java.util.Collection;

public abstract class AbstractFactor
implements Factor {
    protected VarSet vars;

    protected AbstractFactor() {
        this.vars = new HashVarSet();
    }

    protected AbstractFactor(VarSet vars) {
        this.vars = vars;
    }

    protected abstract Factor extractMaxInternal(VarSet var1);

    protected abstract double lookupValueInternal(int var1);

    protected abstract Factor marginalizeInternal(VarSet var1);

    public double value(Assignment assn) {
        return this.lookupValueInternal(assn.singleIndex());
    }

    public double value(AssignmentIterator it) {
        return this.lookupValueInternal(it.indexOfCurrentAssn());
    }

    public double phi(DenseAssignmentIterator it) {
        return this.lookupValueInternal(it.indexOfCurrentAssn());
    }

    public Factor marginalize(Variable[] vars) {
        return this.marginalizeInternal(new HashVarSet(vars));
    }

    public Factor marginalize(Collection vars) {
        return this.marginalizeInternal(new HashVarSet(vars));
    }

    public Factor marginalize(Variable var) {
        return this.marginalizeInternal(new HashVarSet(new Variable[]{var}));
    }

    public Factor marginalizeOut(Variable var) {
        HashVarSet vars = new HashVarSet(this.vars);
        vars.remove(var);
        return this.marginalizeInternal(vars);
    }

    public Factor marginalizeOut(VarSet varset) {
        HashVarSet vars = new HashVarSet(this.vars);
        vars.remove(varset);
        return this.marginalizeInternal(vars);
    }

    public Factor extractMax(Variable[] vars) {
        return this.extractMaxInternal(new HashVarSet(vars));
    }

    public Factor extractMax(Collection vars) {
        return this.extractMaxInternal(new HashVarSet(vars));
    }

    public Factor extractMax(Variable var) {
        return this.extractMaxInternal(new HashVarSet(new Variable[]{var}));
    }

    public int argmax() {
        throw new UnsupportedOperationException(this.toString());
    }

    public Assignment sample(Randoms r) {
        throw new UnsupportedOperationException(this.toString());
    }

    public double sum() {
        throw new UnsupportedOperationException(this.toString());
    }

    public double entropy() {
        throw new UnsupportedOperationException(this.toString());
    }

    public Factor multiply(Factor dist) {
        Factor dup = this.duplicate();
        dup.multiplyBy(dist);
        return dup;
    }

    public void multiplyBy(Factor pot) {
        throw new UnsupportedOperationException("Cannot multiply " + this + " by " + pot);
    }

    public void exponentiate(double power) {
        throw new UnsupportedOperationException("Cannot exponentiate " + this + " by " + power);
    }

    public void divideBy(Factor pot) {
        throw new UnsupportedOperationException("Cannot divide " + this + " by " + pot);
    }

    public boolean isInLogSpace() {
        return false;
    }

    public void logify() {
        throw new UnsupportedOperationException(this.toString());
    }

    public void delogify() {
        throw new UnsupportedOperationException(this.toString());
    }

    public Factor log() {
        throw new UnsupportedOperationException(this.toString());
    }

    public boolean containsVar(Variable var) {
        return this.vars.contains(var);
    }

    public VarSet varSet() {
        return this.vars;
    }

    public AssignmentIterator assignmentIterator() {
        throw new UnsupportedOperationException(this.toString());
    }

    public boolean almostEquals(Factor p) {
        return this.almostEquals(p, 1.0E-5);
    }

    public double logValue(Assignment assn) {
        return Math.log(this.value(assn));
    }

    public double logValue(AssignmentIterator it) {
        return Math.log(this.value(it));
    }

    public double logValue(int loc) {
        throw new UnsupportedOperationException(this.toString());
    }

    public Variable getVariable(int i) {
        return this.vars.get(i);
    }

    public AbstractTableFactor asTable() {
        throw new UnsupportedOperationException(this.toString());
    }

    protected void setVarSet(VarSet vars) {
        this.vars = vars;
    }
}

