/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.Labeling;
import cc.mallet.util.MalletLogger;
import java.util.Arrays;
import java.util.logging.Logger;

public class Csv2FeatureVector
extends Pipe {
    private static Logger logger = MalletLogger.getLogger(Csv2FeatureVector.class.getName());

    public Csv2FeatureVector(int capacity) {
        this.dataAlphabet = new Alphabet(capacity);
    }

    public Csv2FeatureVector() {
        this(1000);
    }

    public Instance pipe(Instance carrier) throws IllegalStateException {
        CharSequence c = (CharSequence)carrier.getData();
        String[] pairs = ((Object)c).toString().trim().split("\\s+");
        Object[] keys = new String[pairs.length];
        double[] values = new double[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            int delimIndex = pairs[i].lastIndexOf(":");
            if (delimIndex <= 0 || delimIndex == pairs[i].length() - 1) {
                throw new IllegalStateException("token is not a valid feature name-feature value pair: " + pairs[i] + "\nfaulting instance name:" + carrier.getName());
            }
            keys[i] = pairs[i].substring(0, delimIndex);
            values[i] = Double.parseDouble(pairs[i].substring(delimIndex + 1));
            this.dataAlphabet.lookupIndex(keys[i], true);
        }
        int[] keyIndices = FeatureVector.getObjectIndices(keys, this.dataAlphabet, true);
        Arrays.sort(keyIndices);
        FeatureVector fv = new FeatureVector(this.dataAlphabet, keyIndices, values);
        if (this.targetAlphabet == null) {
            if (carrier.getTarget() instanceof Labeling) {
                this.targetAlphabet = ((Labeling)carrier.getTarget()).getLabelAlphabet();
            } else {
                throw new IllegalStateException("Instance target is not a Labeling; it is a " + carrier.getTarget().getClass().getName());
            }
        }
        carrier.setData(fv);
        return carrier;
    }
}

