/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TokenTextCharPrefix
extends Pipe
implements Serializable {
    String prefix;
    int prefixLength;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public TokenTextCharPrefix(String prefix, int prefixLength) {
        this.prefix = prefix;
        this.prefixLength = prefixLength;
    }

    public TokenTextCharPrefix() {
        this("PREFIX=", 2);
    }

    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            String s = t.getText();
            if (s.length() <= this.prefixLength) continue;
            t.setFeatureValue((this.prefix + s.substring(0, this.prefixLength)).intern(), 1.0);
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.prefix);
        out.writeInt(this.prefixLength);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.prefix = (String)in.readObject();
        this.prefixLength = in.readInt();
    }
}

