/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3VersionedObjectListService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3AttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(S3AttributesFinderFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final boolean references;

    public S3AttributesFinderFeature(S3Session session) {
        this(session, PreferencesFactory.get().getBoolean("s3.versioning.references.enable"));
    }

    public S3AttributesFinderFeature(S3Session session, boolean references) {
        this.session = session;
        this.references = references;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (file.getType().contains(AbstractPath.Type.upload)) {
            return PathAttributes.EMPTY;
        }
        if (this.containerService.isContainer(file)) {
            PathAttributes attributes = new PathAttributes();
            attributes.setRegion(new S3LocationFeature(this.session, ((RequestEntityRestStorageService)((Object)this.session.getClient())).getRegionEndpointCache()).getLocation(file).getIdentifier());
            return attributes;
        }
        try {
            PathAttributes attr;
            try {
                attr = this.toAttributes((StorageObject)((RequestEntityRestStorageService)((Object)this.session.getClient())).getVersionedObjectDetails(file.attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file)));
            }
            catch (ServiceException e) {
                if (null != e.getResponseHeaders()) {
                    if (e.getResponseHeaders().containsKey("x-amz-delete-marker")) {
                        PathAttributes attr2 = new PathAttributes().withVersionId((String)e.getResponseHeaders().get("x-amz-version-id"));
                        attr2.setCustom(Collections.singletonMap("delete_marker", Boolean.TRUE.toString()));
                        attr2.setDuplicate(true);
                        return attr2;
                    }
                    throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                }
                throw new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
            }
            if (StringUtils.isNotBlank((CharSequence)attr.getVersionId())) {
                if (this.references) {
                    try {
                        AttributedList<Path> list = new S3VersionedObjectListService(this.session, true).list(file, (ListProgressListener)new DisabledListProgressListener());
                        Path versioned = (Path)list.find((Predicate)new DefaultPathPredicate(file));
                        if (null != versioned) {
                            attr.setDuplicate(versioned.attributes().isDuplicate());
                            attr.setVersions(versioned.attributes().getVersions());
                            return attr;
                        }
                    }
                    catch (AccessDeniedException | InteroperabilityException e) {
                        log.warn((Object)String.format("Ignore failure %s reading object versions for %s", e, file));
                    }
                } else {
                    try {
                        String latest = this.toAttributes(((RequestEntityRestStorageService)((Object)this.session.getClient())).getObjectDetails(this.containerService.getContainer(file).getName(), this.containerService.getKey(file))).getVersionId();
                        if (null != latest) {
                            attr.setDuplicate(!latest.equals(attr.getVersionId()));
                        }
                    }
                    catch (ServiceException e) {
                        BackgroundException failure = new S3ExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                        if (failure instanceof NotfoundException) {
                            attr.setCustom(Collections.singletonMap("delete_marker", Boolean.TRUE.toString()));
                            attr.setDuplicate(true);
                        }
                        throw failure;
                    }
                }
            }
            return attr;
        }
        catch (NotfoundException e) {
            if (file.isDirectory()) {
                try {
                    new S3ObjectListService(this.session).list(file, (ListProgressListener)new DisabledListProgressListener(), this.containerService.getKey(file), 1);
                }
                catch (NotfoundException n) {
                    throw e;
                }
                return PathAttributes.EMPTY;
            }
            throw e;
        }
    }

    public PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(object.getContentLength());
        Date lastmodified = object.getLastModifiedDate();
        if (lastmodified != null) {
            attributes.setModificationDate(lastmodified.getTime());
        }
        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
            attributes.setStorageClass(object.getStorageClass());
        } else if (object.containsMetadata("storage-class")) {
            attributes.setStorageClass(object.getMetadataMap().get("storage-class").toString());
        }
        if (StringUtils.isNotBlank((CharSequence)object.getETag())) {
            attributes.setETag(object.getETag());
        }
        if (object instanceof S3Object) {
            attributes.setVersionId(((S3Object)object).getVersionId());
        }
        if (object.containsMetadata("server-side-encryption-aws-kms-key-id")) {
            attributes.setEncryption(new Encryption.Algorithm(object.getServerSideEncryptionAlgorithm(), object.getMetadata("server-side-encryption-aws-kms-key-id").toString()){

                public String getDescription() {
                    return String.format("SSE-KMS (%s)", this.key);
                }
            });
        } else {
            if (null != object.getServerSideEncryptionAlgorithm()) {
                attributes.setEncryption(new Encryption.Algorithm(object.getServerSideEncryptionAlgorithm(), null){

                    public String getDescription() {
                        return "SSE-S3 (AES-256)";
                    }
                });
            }
            attributes.setChecksum(Checksum.parse((String)object.getETag()));
        }
        if (!object.getModifiableMetadata().isEmpty()) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            Map source = object.getModifiableMetadata();
            for (Map.Entry entry : source.entrySet()) {
                metadata.put((String)entry.getKey(), entry.getValue().toString());
            }
            attributes.setMetadata(metadata);
        }
        return attributes;
    }
}

