/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl;

import com.github.sardine.impl.methods.HttpPropFind;
import com.github.sardine.impl.methods.HttpReport;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class SardineRedirectStrategy
extends DefaultRedirectStrategy {
    protected boolean isRedirectable(String method) {
        if (super.isRedirectable(method)) {
            return true;
        }
        return method.equalsIgnoreCase("PROPFIND");
    }

    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("PROPFIND")) {
            HttpPropFind propfind = new HttpPropFind(this.getLocationURI(request, response, context));
            Header depth = request.getFirstHeader("Depth");
            if (depth != null && depth.getValue() != null) {
                propfind.setDepth(depth.getValue());
            }
            return this.copyEntity(propfind, request);
        }
        if (method.equalsIgnoreCase("REPORT")) {
            HttpReport report = new HttpReport(this.getLocationURI(request, response, context));
            Header depth = request.getFirstHeader("Depth");
            if (depth != null && depth.getValue() != null) {
                report.setDepth(depth.getValue());
            }
            return this.copyEntity(report, request);
        }
        return super.getRedirect(request, response, context);
    }

    private HttpUriRequest copyEntity(HttpEntityEnclosingRequestBase redirect, HttpRequest original) {
        if (original instanceof HttpEntityEnclosingRequest) {
            redirect.setEntity(((HttpEntityEnclosingRequest)original).getEntity());
        }
        return redirect;
    }
}

