/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public final class MetadataStringManipulation {
    private static final String HTTP_HEADER_KEY_SAFE_CHARS = "!#$&'*-.~^_`|";
    private static final String HTTP_HEADER_VALUE_SAFE_CHARS = "()<>@,;:\"/\\[]?={}!#$&'*-.~^_`|";
    private static final Escaper HTTP_HEADER_KEY_ESCAPER = new PercentEscaper("!#$&'*-.~^_`|", false);
    private static final Escaper HTTP_HEADER_VALUE_ESCAPER = new PercentEscaper("()<>@,;:\"/\\[]?={}!#$&'*-.~^_`|", false);

    private MetadataStringManipulation() {
    }

    public static String toEncodedKeyString(String str) {
        if (str == null) {
            return null;
        }
        String strUtf8 = new String(str.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        return MetadataStringManipulation.getMetadataKeyEscaper().escape(strUtf8);
    }

    public static String toEncodedValueString(String str) {
        if (str == null) {
            return null;
        }
        String strUtf8 = new String(str.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        return MetadataStringManipulation.getMetadataValueEscaper().escape(strUtf8);
    }

    public static String toDecodedString(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode string: " + str, e);
        }
    }

    private static Escaper getMetadataKeyEscaper() {
        return HTTP_HEADER_KEY_ESCAPER;
    }

    private static Escaper getMetadataValueEscaper() {
        return HTTP_HEADER_VALUE_ESCAPER;
    }
}

