/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaObject;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class MantaObjectConversionFunction
implements Function<Map<String, Object>, MantaObject> {
    private static final String NAME_FIELD_KEY = "name";
    private static final String MTIME_FIELD_KEY = "mtime";
    private static final String TYPE_FIELD_KEY = "type";
    private static final String PATH_FIELD_KEY = "path";
    private static final String CONTENT_TYPE_FIELD_KEY = "contentType";
    private static final String ETAG_FIELD_KEY = "etag";
    private static final String SIZE_FIELD_KEY = "size";
    private static final String DURABILITY_FIELD_KEY = "durability";
    private static final String CONTENT_MD5_FIELD_KEY = "contentMD5";
    public static final MantaObjectConversionFunction INSTANCE = new MantaObjectConversionFunction();

    @Override
    public MantaObject apply(Map<String, Object> item) {
        String durabilityString;
        String name = Validate.notNull((Object)item.get(NAME_FIELD_KEY), (String)"Filename is null", (Object[])new Object[0]).toString();
        String mtime = Validate.notNull((Object)item.get(MTIME_FIELD_KEY), (String)"Modification time is null", (Object[])new Object[0]).toString();
        String type = Validate.notNull((Object)item.get(TYPE_FIELD_KEY), (String)"File type is null", (Object[])new Object[0]).toString();
        String objPath = String.format("%s%s%s", StringUtils.removeEnd((String)item.get(PATH_FIELD_KEY).toString(), (String)"/"), "/", StringUtils.removeStart((String)name, (String)"/"));
        MantaHttpHeaders headers = new MantaHttpHeaders();
        headers.setLastModified(mtime);
        if (item.containsKey(CONTENT_TYPE_FIELD_KEY)) {
            String contentType = Objects.toString(item.get(CONTENT_TYPE_FIELD_KEY), null);
            headers.setContentType(contentType);
        } else if (type.equals("directory")) {
            headers.setContentType("application/x-json-stream; type=directory");
        }
        if (item.containsKey(ETAG_FIELD_KEY)) {
            headers.setETag(Objects.toString(item.get(ETAG_FIELD_KEY)));
        }
        if (item.containsKey(SIZE_FIELD_KEY)) {
            long size = Long.parseLong(Objects.toString(item.get(SIZE_FIELD_KEY)));
            headers.setContentLength(size);
        }
        if (item.containsKey(DURABILITY_FIELD_KEY) && (durabilityString = Objects.toString(item.get(DURABILITY_FIELD_KEY))) != null) {
            int durability = Integer.parseInt(durabilityString);
            headers.setDurabilityLevel(durability);
        }
        if (item.containsKey(CONTENT_MD5_FIELD_KEY)) {
            String contentMD5 = Objects.toString(item.get(CONTENT_MD5_FIELD_KEY), null);
            headers.setContentMD5(contentMD5);
        }
        return new MantaObjectResponse(MantaUtils.formatPath(objPath), headers);
    }
}

