/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.GraphItemListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointListService;
import ch.cyberduck.core.onedrive.features.sharepoint.SiteDrivesListService;
import ch.cyberduck.core.onedrive.features.sharepoint.SitesListService;
import java.util.Optional;

public abstract class AbstractSharepointListService
implements ListService {
    private final AbstractSharepointSession session;
    private final IdProvider idProvider;

    public AbstractSharepointListService(AbstractSharepointSession session, IdProvider idProvider) {
        this.session = session;
        this.idProvider = idProvider;
    }

    public AbstractSharepointSession getSession() {
        return this.session;
    }

    public IdProvider getIdProvider() {
        return this.idProvider;
    }

    public final AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return this.getRoot(directory, listener);
        }
        AttributedList<Path> result = this.processList(directory, listener);
        if (result != AttributedList.emptyList()) {
            return result;
        }
        GraphSession.ContainerItem container = this.session.getContainer(directory);
        if (container.getCollectionPath().map(p -> container.isContainerInCollection() && "Sites".equals(p.getName())).orElse(false).booleanValue()) {
            return this.addSiteItems(directory, listener);
        }
        Optional<ListService> collectionListService = container.getCollectionPath().map(p -> {
            if ("Sites".equals(p.getName())) {
                return new SitesListService(this.session);
            }
            if ("Drives".equals(p.getName())) {
                return new SiteDrivesListService(this.session);
            }
            return null;
        });
        if (collectionListService.isPresent() && (!container.isDefined() || container.isCollectionInContainer())) {
            return collectionListService.get().list(directory, listener);
        }
        return new GraphItemListService(this.session).list(directory, listener);
    }

    public ListService withCache(Cache<Path> cache) {
        this.idProvider.withCache(cache);
        return this;
    }

    AttributedList<Path> addSiteItems(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList list = new AttributedList();
        list.add((Referenceable)new Path(directory, SharepointListService.DRIVES_NAME.getName(), SharepointListService.DRIVES_NAME.getType(), SharepointListService.DRIVES_NAME.attributes()));
        list.add((Referenceable)new Path(directory, SharepointListService.SITES_NAME.getName(), SharepointListService.SITES_NAME.getType(), SharepointListService.SITES_NAME.attributes()));
        listener.chunk(directory, list);
        return list;
    }

    abstract AttributedList<Path> getRoot(Path var1, ListProgressListener var2) throws BackgroundException;

    AttributedList<Path> processList(Path directory, ListProgressListener listener) throws BackgroundException {
        return AttributedList.emptyList();
    }
}

