/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ErrorResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="S3 file upload status information")
public class S3ShareUploadStatus {
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="fileName")
    private String fileName = null;
    @JsonProperty(value="size")
    private Long size = null;
    @JsonProperty(value="errorDetails")
    private ErrorResponse errorDetails = null;

    public S3ShareUploadStatus status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="S3 file upload status:  * `transfer` - upload in progress  * `finishing` - completing file upload  * `done` - file upload successully done  * `error` - an error occurred while file upload")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public S3ShareUploadStatus fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Schema(required=true, description="File name")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public S3ShareUploadStatus size(Long size) {
        this.size = size;
        return this;
    }

    @Schema(description="File size in byte")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public S3ShareUploadStatus errorDetails(ErrorResponse errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Schema(description="")
    public ErrorResponse getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorResponse errorDetails) {
        this.errorDetails = errorDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ShareUploadStatus s3ShareUploadStatus = (S3ShareUploadStatus)o;
        return Objects.equals(this.status, s3ShareUploadStatus.status) && Objects.equals(this.fileName, s3ShareUploadStatus.fileName) && Objects.equals(this.size, s3ShareUploadStatus.size) && Objects.equals(this.errorDetails, s3ShareUploadStatus.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.fileName, this.size, this.errorDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class S3ShareUploadStatus {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

