/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.CryptoUtils;
import com.dracoon.sdk.crypto.FileEncryptionCipher;
import com.dracoon.sdk.crypto.error.CryptoException;
import com.dracoon.sdk.crypto.error.CryptoSystemException;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.log4j.Logger;

public class TripleCryptOutputStream<VersionId>
extends HttpResponseOutputStream<VersionId> {
    private static final Logger log = Logger.getLogger(TripleCryptOutputStream.class);
    private final StatusOutputStream<VersionId> proxy;

    public TripleCryptOutputStream(SDSSession session, StatusOutputStream<VersionId> proxy, FileEncryptionCipher cipher, TransferStatus key) {
        super((OutputStream)new MemorySegementingOutputStream((OutputStream)((Object)new EncryptingOutputStream(session, (OutputStream)proxy, cipher, key)), Integer.valueOf(16)));
        this.proxy = proxy;
    }

    public void write(int b) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    public VersionId getStatus() throws BackgroundException {
        return (VersionId)this.proxy.getStatus();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private static final class EncryptingOutputStream
    extends ProxyOutputStream {
        private final SDSSession session;
        private final FileEncryptionCipher cipher;
        private final TransferStatus status;

        public EncryptingOutputStream(SDSSession session, OutputStream proxy, FileEncryptionCipher cipher, TransferStatus key) {
            super(proxy);
            this.session = session;
            this.cipher = cipher;
            this.status = key;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                for (int chunkOffset = off; chunkOffset < len; chunkOffset += 16) {
                    int chunkLen = Math.min(16, len - chunkOffset);
                    byte[] bytes = Arrays.copyOfRange(b, chunkOffset, chunkOffset + chunkLen);
                    PlainDataContainer data = EncryptingOutputStream.createPlainDataContainer(bytes, bytes.length);
                    EncryptedDataContainer encrypted = this.cipher.processBytes(data);
                    super.write(encrypted.getContent());
                }
            }
            catch (CryptoException e) {
                throw new IOException(e);
            }
        }

        public void close() throws IOException {
            try {
                EncryptedDataContainer encrypted = this.cipher.doFinal();
                super.write(encrypted.getContent());
                String tag = CryptoUtils.byteArrayToString((byte[])encrypted.getTag());
                ObjectReader reader = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                FileKey fileKey = (FileKey)reader.readValue(this.status.getFilekey().array());
                if (null == fileKey.getTag()) {
                    fileKey.setTag(tag);
                    ObjectWriter writer = ((SDSApiClient)this.session.getClient()).getJSON().getContext(null).writerFor(FileKey.class);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    writer.writeValue((OutputStream)out, (Object)fileKey);
                    this.status.setFilekey(ByteBuffer.wrap(out.toByteArray()));
                } else {
                    log.warn((Object)String.format("Skip setting tag in file key already found in %s", this.status));
                }
            }
            catch (CryptoSystemException e) {
                throw new IOException(e);
            }
            finally {
                super.close();
            }
        }

        private static PlainDataContainer createPlainDataContainer(byte[] bytes, int len) {
            byte[] b = new byte[len];
            System.arraycopy(bytes, 0, b, 0, len);
            return new PlainDataContainer(b);
        }
    }
}

