/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import com.hierynomus.asn1.ASN1OutputStream;
import com.hierynomus.asn1.encodingrules.ASN1Encoder;
import com.hierynomus.asn1.encodingrules.der.DEREncoder;
import com.hierynomus.asn1.types.ASN1Object;
import com.hierynomus.asn1.types.constructed.ASN1Sequence;
import com.hierynomus.asn1.types.primitive.ASN1Integer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.signature.AbstractSignature;
import net.schmizz.sshj.signature.Signature;

public class SignatureDSA
extends AbstractSignature {
    public SignatureDSA() {
        super("SHA1withDSA", KeyType.DSA.toString());
    }

    @Override
    public byte[] encode(byte[] sig) {
        int rIndex = 3;
        int rLen = sig[rIndex++] & 0xFF;
        byte[] r = new byte[rLen];
        System.arraycopy(sig, rIndex, r, 0, r.length);
        int sIndex = rIndex + rLen + 1;
        int sLen = sig[sIndex++] & 0xFF;
        byte[] s = new byte[sLen];
        System.arraycopy(sig, sIndex, s, 0, s.length);
        byte[] result = new byte[40];
        int r_copylen = Math.min(r.length, 20);
        int s_copylen = Math.min(s.length, 20);
        System.arraycopy(r, r.length - r_copylen, result, 20 - r_copylen, r_copylen);
        System.arraycopy(s, s.length - s_copylen, result, 40 - s_copylen, s_copylen);
        return result;
    }

    @Override
    public boolean verify(byte[] sig) {
        try {
            byte[] sigBlob = this.extractSig(sig, "ssh-dss");
            return this.signature.verify(this.asnEncode(sigBlob));
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
        catch (IOException e) {
            throw new SSHRuntimeException(e);
        }
    }

    private byte[] asnEncode(byte[] sigBlob) throws IOException {
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(sigBlob, 0, 20));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(sigBlob, 20, 40));
        ArrayList<ASN1Integer> vector = new ArrayList<ASN1Integer>();
        vector.add(new ASN1Integer(r));
        vector.add(new ASN1Integer(s));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream asn1OutputStream = new ASN1OutputStream((ASN1Encoder)new DEREncoder(), (OutputStream)baos);
        asn1OutputStream.writeObject((ASN1Object)new ASN1Sequence(vector));
        asn1OutputStream.flush();
        return baos.toByteArray();
    }

    public static class Factory
    implements Factory.Named<Signature> {
        @Override
        public Signature create() {
            return new SignatureDSA();
        }

        @Override
        public String getName() {
            return KeyType.DSA.toString();
        }
    }
}

