/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.http.HttpSession;

public class CryptoTransferAccelerationFeature<C extends HttpSession<?>>
implements TransferAcceleration {
    private final Session<?> session;
    private final TransferAcceleration delegate;
    private final Vault vault;

    public CryptoTransferAccelerationFeature(Session<?> session, TransferAcceleration delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public boolean getStatus(Path file) throws BackgroundException {
        return this.delegate.getStatus(this.vault.encrypt(this.session, file));
    }

    public void setStatus(Path file, boolean enabled) throws BackgroundException {
        this.delegate.setStatus(this.vault.encrypt(this.session, file), enabled);
    }

    public boolean prompt(Host bookmark, Path file, ConnectionCallback prompt) throws BackgroundException {
        return this.delegate.prompt(bookmark, this.vault.encrypt(this.session, file), prompt);
    }

    public void configure(boolean enable, Path file) throws BackgroundException {
        this.delegate.configure(enable, this.vault.encrypt(this.session, file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoTransferAccelerationFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

