/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryLoggingFeature
implements Logging {
    private final Session<?> session;
    private final Logging proxy;
    private final VaultRegistry registry;

    public VaultRegistryLoggingFeature(Session<?> session, Logging proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public LoggingConfiguration getConfiguration(Path container) throws BackgroundException {
        return this.registry.find(this.session, container).getFeature(this.session, Logging.class, this.proxy).getConfiguration(container);
    }

    @Override
    public void setConfiguration(Path container, LoggingConfiguration configuration) throws BackgroundException {
        this.registry.find(this.session, container).getFeature(this.session, Logging.class, this.proxy).setConfiguration(container, configuration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryLoggingFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

