/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.handler;

import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.exception.NotFoundException;
import ch.iterate.openstack.swift.model.CDNContainer;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class CdnContainerInfoHandler
implements ResponseHandler<CDNContainer> {
    private Region region;
    private String container;

    public CdnContainerInfoHandler(Region region, String container) {
        this.region = region;
        this.container = container;
    }

    public CDNContainer handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        if (response.getStatusLine().getStatusCode() == 204 || response.getStatusLine().getStatusCode() == 200) {
            CDNContainer result = new CDNContainer(this.region, this.container);
            result.setCdnURL(this.getCdnUrl(response));
            result.setSslURL(this.getCdnSslUrl(response));
            result.setStreamingURL(this.getCdnStreamingUrl(response));
            result.setiOSStreamingURL(this.getCdnIosStreamingUrl(response));
            for (Header header : response.getAllHeaders()) {
                String name = header.getName().toLowerCase();
                if ("X-CDN-Enabled".equalsIgnoreCase(name)) {
                    result.setEnabled(Boolean.valueOf(header.getValue()));
                    continue;
                }
                if ("X-Log-Retention".equalsIgnoreCase(name)) {
                    result.setRetainLogs(Boolean.valueOf(header.getValue()));
                    continue;
                }
                if ("X-TTL".equalsIgnoreCase(name)) {
                    result.setTtl(Integer.parseInt(header.getValue()));
                    continue;
                }
                if ("X-Referrer-ACL ".equalsIgnoreCase(name)) {
                    result.setReferrerACL(header.getValue());
                    continue;
                }
                if (!"X-User-Agent-ACL".equalsIgnoreCase(name)) continue;
                result.setUserAgentACL(header.getValue());
            }
            return result;
        }
        if (response.getStatusLine().getStatusCode() == 404) {
            throw new NotFoundException(new Response(response));
        }
        if (response.getStatusLine().getStatusCode() == 401) {
            throw new AuthorizationException(new Response(response));
        }
        throw new GenericException(new Response(response));
    }

    private String getCdnUrl(HttpResponse response) {
        Header cdnHeader = response.getFirstHeader("X-CDN-URI");
        if (cdnHeader != null) {
            return cdnHeader.getValue();
        }
        return null;
    }

    private String getCdnSslUrl(HttpResponse response) {
        Header cdnHeader = response.getFirstHeader("X-CDN-SSL-URI");
        if (cdnHeader != null) {
            return cdnHeader.getValue();
        }
        return null;
    }

    private String getCdnStreamingUrl(HttpResponse response) {
        Header cdnHeader = response.getFirstHeader("X-CDN-Streaming-URI");
        if (cdnHeader != null) {
            return cdnHeader.getValue();
        }
        return null;
    }

    private String getCdnIosStreamingUrl(HttpResponse response) {
        Header cdnHeader = response.getFirstHeader("X-Cdn-Ios-Uri");
        if (cdnHeader != null) {
            return cdnHeader.getValue();
        }
        return null;
    }
}

