/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.stone.StoneSerializer;
import com.dropbox.core.stone.StoneSerializers;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class LocalizedText {
    private final String text;
    private final String locale;
    static final StoneSerializer<LocalizedText> STONE_SERIALIZER = new StoneSerializer<LocalizedText>(){

        @Override
        public void serialize(LocalizedText value, JsonGenerator g) throws IOException, JsonGenerationException {
            throw new UnsupportedOperationException("Error wrapper serialization not supported.");
        }

        @Override
        public LocalizedText deserialize(JsonParser p) throws IOException, JsonParseException {
            String text = null;
            String locale = null;
            1.expectStartObject(p);
            while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String field = p.getCurrentName();
                p.nextToken();
                if ("text".equals(field)) {
                    text = StoneSerializers.string().deserialize(p);
                    continue;
                }
                if ("locale".equals(field)) {
                    locale = StoneSerializers.string().deserialize(p);
                    continue;
                }
                1.skipValue(p);
            }
            if (text == null) {
                throw new JsonParseException(p, "Required field \"text\" missing.");
            }
            if (locale == null) {
                throw new JsonParseException(p, "Required field \"locale\" missing.");
            }
            LocalizedText value = new LocalizedText(text, locale);
            1.expectEndObject(p);
            return value;
        }
    };

    public LocalizedText(String text, String locale) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        this.text = text;
        this.locale = locale;
    }

    public String getText() {
        return this.text;
    }

    public String getLocale() {
        return this.locale;
    }

    public String toString() {
        return this.text;
    }
}

