/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.notifications.GetObjectLostNotificationRegistrationSpectraS3Response;
import com.spectralogic.ds3client.models.S3ObjectLostNotificationRegistration;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetObjectLostNotificationRegistrationSpectraS3ResponseParser
extends AbstractResponseParser<GetObjectLostNotificationRegistrationSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetObjectLostNotificationRegistrationSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        S3ObjectLostNotificationRegistration result = XmlOutput.fromXml(inputStream, S3ObjectLostNotificationRegistration.class);
                        GetObjectLostNotificationRegistrationSpectraS3Response getObjectLostNotificationRegistrationSpectraS3Response = new GetObjectLostNotificationRegistrationSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getObjectLostNotificationRegistrationSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

