/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift;

import ch.iterate.openstack.swift.AuthenticationResponse;
import ch.iterate.openstack.swift.Constants;
import ch.iterate.openstack.swift.Response;
import ch.iterate.openstack.swift.exception.AuthorizationException;
import ch.iterate.openstack.swift.exception.ContainerExistsException;
import ch.iterate.openstack.swift.exception.ContainerNotEmptyException;
import ch.iterate.openstack.swift.exception.ContainerNotFoundException;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.exception.NotFoundException;
import ch.iterate.openstack.swift.handler.AccountInfoHandler;
import ch.iterate.openstack.swift.handler.Authentication10ResponseHandler;
import ch.iterate.openstack.swift.handler.AuthenticationJson11ResponseHandler;
import ch.iterate.openstack.swift.handler.AuthenticationJson20ResponseHandler;
import ch.iterate.openstack.swift.handler.AuthenticationJson3ResponseHandler;
import ch.iterate.openstack.swift.handler.CdnContainerInfoHandler;
import ch.iterate.openstack.swift.handler.CdnContainerInfoListHandler;
import ch.iterate.openstack.swift.handler.ContainerInfoHandler;
import ch.iterate.openstack.swift.handler.ContainerInfoResponseHandler;
import ch.iterate.openstack.swift.handler.ContainerMetadataResponseHandler;
import ch.iterate.openstack.swift.handler.ContainerResponseHandler;
import ch.iterate.openstack.swift.handler.DefaultResponseHandler;
import ch.iterate.openstack.swift.handler.ObjectMetadataResponseHandler;
import ch.iterate.openstack.swift.handler.ObjectResponseHandler;
import ch.iterate.openstack.swift.io.SubInputStream;
import ch.iterate.openstack.swift.method.Authentication10UsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication11UsernameKeyRequest;
import ch.iterate.openstack.swift.method.Authentication20UsernamePasswordRequest;
import ch.iterate.openstack.swift.method.Authentication3UsernamePasswordProjectRequest;
import ch.iterate.openstack.swift.method.AuthenticationRequest;
import ch.iterate.openstack.swift.model.AccountInfo;
import ch.iterate.openstack.swift.model.CDNContainer;
import ch.iterate.openstack.swift.model.Container;
import ch.iterate.openstack.swift.model.ContainerInfo;
import ch.iterate.openstack.swift.model.ContainerMetadata;
import ch.iterate.openstack.swift.model.ObjectMetadata;
import ch.iterate.openstack.swift.model.Region;
import ch.iterate.openstack.swift.model.StorageObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;

public class Client {
    private CloseableHttpClient client;
    private AuthenticationRequest authenticationRequest;
    private AuthenticationResponse authenticationResponse;

    public Client(int connectionTimeOut) {
        this(HttpClients.custom().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(connectionTimeOut).build()).build());
    }

    public Client(CloseableHttpClient client) {
        this.client = client;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public void disconnect() throws IOException {
        this.client.close();
    }

    public AuthenticationResponse authenticate(AuthVersion authVersion, URI authenticationURL, String username, String password, String tenantId) throws IOException {
        switch (authVersion) {
            default: {
                return this.authenticate(new Authentication10UsernameKeyRequest(authenticationURL, username, password));
            }
            case v11: {
                return this.authenticate(new Authentication11UsernameKeyRequest(authenticationURL, username, password));
            }
            case v20: {
                return this.authenticate(new Authentication20UsernamePasswordRequest(authenticationURL, username, password, tenantId));
            }
            case v3: 
        }
        return this.authenticate(new Authentication3UsernamePasswordProjectRequest(authenticationURL, username, password, tenantId));
    }

    public AuthenticationResponse authenticate(AuthenticationRequest request) throws IOException {
        switch (request.getVersion()) {
            default: {
                return this.authenticate(request, new Authentication10ResponseHandler());
            }
            case v11: {
                return this.authenticate(request, new AuthenticationJson11ResponseHandler());
            }
            case v20: {
                return this.authenticate(request, new AuthenticationJson20ResponseHandler());
            }
            case v3: 
        }
        return this.authenticate(request, new AuthenticationJson3ResponseHandler());
    }

    public AuthenticationResponse authenticate(AuthenticationRequest request, ResponseHandler<AuthenticationResponse> handler) throws IOException {
        this.authenticationRequest = request;
        this.authenticationResponse = (AuthenticationResponse)this.client.execute((HttpUriRequest)request, handler);
        return this.authenticationResponse;
    }

    public AuthenticationResponse getAuthentication() {
        return this.authenticationResponse;
    }

    public Set<Region> getRegions() {
        return this.authenticationResponse.getRegions();
    }

    public List<ContainerInfo> listContainersInfo(Region region) throws IOException {
        return this.listContainersInfo(region, -1, null);
    }

    public List<ContainerInfo> listContainersInfo(Region region, int limit) throws IOException {
        return this.listContainersInfo(region, limit, null);
    }

    public List<ContainerInfo> listContainersInfo(Region region, int limit, String marker) throws IOException {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        if (limit > 0) {
            parameters.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (marker != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("marker", marker));
        }
        parameters.add((NameValuePair)new BasicNameValuePair("format", "xml"));
        HttpGet method = new HttpGet(region.getStorageUrl(parameters));
        return this.execute((HttpRequestBase)method, new ContainerInfoResponseHandler(region));
    }

    public List<Container> listContainers(Region region) throws IOException {
        return this.listContainers(region, -1, null);
    }

    public List<Container> listContainers(Region region, int limit) throws IOException {
        return this.listContainers(region, limit, null);
    }

    public List<Container> listContainers(Region region, int limit, String marker) throws IOException {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        if (limit > 0) {
            parameters.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (marker != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("marker", marker));
        }
        HttpGet method = new HttpGet(region.getStorageUrl(parameters));
        return this.execute((HttpRequestBase)method, new ContainerResponseHandler(region));
    }

    protected void authorize(HttpRequestBase method) {
        method.setHeader("X-Auth-Token", this.authenticationResponse.getAuthToken());
    }

    private Response execute(HttpRequestBase method) throws IOException {
        try {
            this.authorize(method);
            try {
                return new DefaultResponseHandler().handleResponse((HttpResponse)this.client.execute((HttpUriRequest)method));
            }
            catch (AuthorizationException e) {
                method.abort();
                this.authenticationResponse = this.authenticate(this.authenticationRequest);
                method.reset();
                this.authorize(method);
                return new DefaultResponseHandler().handleResponse((HttpResponse)this.client.execute((HttpUriRequest)method));
            }
        }
        catch (IOException e) {
            method.abort();
            throw e;
        }
    }

    private <T> T execute(HttpRequestBase method, ResponseHandler<T> handler) throws IOException {
        try {
            Object object;
            this.authorize(method);
            try {
                object = this.client.execute((HttpUriRequest)method, handler);
            }
            catch (AuthorizationException e) {
                Object object2;
                try {
                    method.abort();
                    this.authenticationResponse = this.authenticate(this.authenticationRequest);
                    method.reset();
                    this.authorize(method);
                    object2 = this.client.execute((HttpUriRequest)method, handler);
                }
                catch (IOException e2) {
                    method.abort();
                    throw e2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                method.reset();
                return (T)object2;
            }
            return (T)object;
        }
        finally {
            method.reset();
        }
    }

    public List<StorageObject> listObjectsStartingWith(Region region, String container, String startsWith, String path, int limit, String marker) throws IOException {
        return this.listObjectsStartingWith(region, container, startsWith, path, limit, marker, null);
    }

    public List<StorageObject> listObjectsStartingWith(Region region, String container, String startsWith, String path, int limit, String marker, Character delimiter) throws IOException {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("format", "xml"));
        if (startsWith != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("prefix", startsWith));
        }
        if (path != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("path", path));
        }
        if (limit > 0) {
            parameters.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (marker != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("marker", marker));
        }
        if (delimiter != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("delimiter", delimiter.toString()));
        }
        HttpGet method = new HttpGet(region.getStorageUrl(container, parameters));
        return this.execute((HttpRequestBase)method, new ObjectResponseHandler());
    }

    public List<StorageObject> listObjects(Region region, String container) throws IOException {
        return this.listObjectsStartingWith(region, container, null, null, -1, null, null);
    }

    public List<StorageObject> listObjects(Region region, String container, Character delimiter) throws IOException {
        return this.listObjectsStartingWith(region, container, null, null, -1, null, delimiter);
    }

    public List<StorageObject> listObjects(Region region, String container, int limit) throws IOException {
        return this.listObjectsStartingWith(region, container, null, null, limit, null, null);
    }

    public List<StorageObject> listObjects(Region region, String container, String path) throws IOException {
        return this.listObjectsStartingWith(region, container, null, path, -1, null, null);
    }

    public List<StorageObject> listObjects(Region region, String container, String path, Character delimiter) throws IOException {
        return this.listObjectsStartingWith(region, container, null, path, -1, null, delimiter);
    }

    public List<StorageObject> listObjects(Region region, String container, String path, int limit) throws IOException {
        return this.listObjectsStartingWith(region, container, null, path, limit, null);
    }

    public List<StorageObject> listObjects(Region region, String container, String path, int limit, String marker) throws IOException {
        return this.listObjectsStartingWith(region, container, null, path, limit, marker);
    }

    public List<StorageObject> listObjects(Region region, String container, int limit, String marker) throws IOException {
        return this.listObjectsStartingWith(region, container, null, null, limit, marker);
    }

    public boolean containerExists(Region region, String container) throws IOException {
        try {
            this.getContainerInfo(region, container);
            return true;
        }
        catch (ContainerNotFoundException notfound) {
            return false;
        }
    }

    public AccountInfo getAccountInfo(Region region) throws IOException {
        HttpHead method = new HttpHead(region.getStorageUrl());
        return this.execute((HttpRequestBase)method, new AccountInfoHandler());
    }

    public ContainerInfo getContainerInfo(Region region, String container) throws IOException {
        HttpHead method = new HttpHead(region.getStorageUrl(container));
        return this.execute((HttpRequestBase)method, new ContainerInfoHandler(region, container));
    }

    public void createContainer(Region region, String name) throws IOException {
        HttpPut method = new HttpPut(region.getStorageUrl(name));
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 201) {
            return;
        }
        if (response.getStatusCode() == 202) {
            throw new ContainerExistsException(response);
        }
        throw new GenericException(response);
    }

    public void deleteContainer(Region region, String name) throws IOException {
        HttpDelete method = new HttpDelete(region.getStorageUrl(name));
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 409) {
            throw new ContainerNotEmptyException(response);
        }
    }

    public String cdnEnableContainer(Region region, String name) throws IOException {
        HttpPut method = new HttpPut(region.getCDNManagementUrl(name));
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 201 || response.getStatusCode() == 202) {
            return response.getResponseHeader("X-CDN-URI").getValue();
        }
        throw new GenericException(response);
    }

    public String cdnUpdateContainer(Region region, String name, int ttl, boolean enabled, boolean retainLogs) throws IOException {
        return this.cdnUpdateContainer(region, name, ttl, enabled, null, null, retainLogs);
    }

    private String cdnUpdateContainer(Region region, String name, int ttl, boolean enabled, String referrerAcl, String userAgentACL, boolean retainLogs) throws IOException {
        Response response;
        HttpPost method = new HttpPost(region.getCDNManagementUrl(name));
        if (ttl > 0) {
            method.setHeader("X-TTL", Integer.toString(ttl));
        }
        method.setHeader("X-CDN-Enabled", Boolean.toString(enabled));
        method.setHeader("X-Log-Retention", Boolean.toString(retainLogs));
        if (referrerAcl != null) {
            method.setHeader("X-Referrer-ACL ", referrerAcl);
        }
        if (userAgentACL != null) {
            method.setHeader("X-User-Agent-ACL", userAgentACL);
        }
        if ((response = this.execute((HttpRequestBase)method, new DefaultResponseHandler())).getStatusCode() == 202) {
            return response.getResponseHeader("X-CDN-URI").getValue();
        }
        throw new GenericException(response);
    }

    public CDNContainer getCDNContainerInfo(Region region, String container) throws IOException {
        HttpHead method = new HttpHead(region.getCDNManagementUrl(container));
        return this.execute((HttpRequestBase)method, new CdnContainerInfoHandler(region, container));
    }

    public boolean isCDNEnabled(Region region, String container) throws IOException {
        CDNContainer info = this.getCDNContainerInfo(region, container);
        return info.isEnabled();
    }

    public void createPath(Region region, String container, String path) throws IOException {
        this.storeObject(region, container, new ByteArrayInputStream(new byte[0]), "application/directory", path, new HashMap<String, String>());
    }

    public void purgeCDNContainer(Region region, String container, String emailAddresses) throws IOException {
        HttpDelete method = new HttpDelete(region.getCDNManagementUrl(container));
        if (emailAddresses != null) {
            method.setHeader("X-Purge-Email", emailAddresses);
        }
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public void purgeCDNObject(Region region, String container, String object, String emailAddresses) throws IOException {
        HttpDelete method = new HttpDelete(region.getCDNManagementUrl(container, object));
        if (emailAddresses != null) {
            method.setHeader("X-Purge-Email", emailAddresses);
        }
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public List<CDNContainer> listCdnContainerInfo(Region region) throws IOException {
        return this.listCdnContainerInfo(region, -1, null);
    }

    public List<CDNContainer> listCdnContainerInfo(Region region, int limit) throws IOException {
        return this.listCdnContainerInfo(region, limit, null);
    }

    public List<CDNContainer> listCdnContainerInfo(Region region, int limit, String marker) throws IOException {
        LinkedList<NameValuePair> params = new LinkedList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("format", "xml"));
        if (limit > 0) {
            params.add((NameValuePair)new BasicNameValuePair("limit", String.valueOf(limit)));
        }
        if (marker != null) {
            params.add((NameValuePair)new BasicNameValuePair("marker", marker));
        }
        HttpGet method = new HttpGet(region.getCDNManagementUrl(params));
        return this.execute((HttpRequestBase)method, new CdnContainerInfoListHandler(region));
    }

    public String createDLOManifestObject(Region region, String container, String contentType, String name, String commonPrefix) throws IOException {
        return this.createDLOManifestObject(region, container, contentType, name, commonPrefix, new HashMap<String, String>());
    }

    public String createDLOManifestObject(Region region, String container, String contentType, String name, String commonPrefix, Map<String, String> metadata) throws IOException {
        byte[] arr = new byte[]{};
        HttpPut method = new HttpPut(region.getStorageUrl(container, name));
        method.setHeader("X-Object-Manifest", commonPrefix);
        ByteArrayEntity entity = new ByteArrayEntity(arr);
        entity.setContentType(contentType);
        method.setEntity((HttpEntity)entity);
        for (Map.Entry<String, String> key : this.renameObjectMetadata(metadata).entrySet()) {
            method.setHeader(key.getKey(), key.getValue());
        }
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 201) {
            return response.getResponseHeader("ETag").getValue();
        }
        throw new GenericException(response);
    }

    public String createSLOManifestObject(Region region, String container, String contentType, String name, String manifest, Map<String, String> metadata) throws IOException {
        String manifestEtag;
        URIBuilder urlBuild = new URIBuilder(region.getStorageUrl(container, name));
        urlBuild.setParameter("multipart-manifest", "put");
        try {
            URI url = urlBuild.build();
            InputStreamEntity manifestEntity = new InputStreamEntity((InputStream)new ByteArrayInputStream(manifest.getBytes()), -1L);
            manifestEntity.setChunked(true);
            manifestEntity.setContentType(contentType);
            HttpPut method = new HttpPut(url);
            method.setEntity((HttpEntity)manifestEntity);
            for (Map.Entry<String, String> key : this.renameObjectMetadata(metadata).entrySet()) {
                method.setHeader(key.getKey(), key.getValue());
            }
            method.setHeader("X-Static-Large-Object", "true");
            Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
            if (response.getStatusCode() != 201) {
                throw new GenericException(response);
            }
            manifestEtag = response.getResponseHeader("ETag").getValue();
        }
        catch (URISyntaxException ex) {
            throw new GenericException("URI Building failed when creating Static Large Object manifest", ex);
        }
        return manifestEtag;
    }

    public Map<String, List<StorageObject>> listObjectSegments(Region region, String container, String name) throws IOException {
        HashMap<String, List<StorageObject>> existingSegments;
        block9: {
            existingSegments = new HashMap<String, List<StorageObject>>();
            try {
                ObjectMetadata existingMetadata = this.getObjectMetaData(region, container, name);
                if (existingMetadata.getMetaData().containsKey("X-Object-Manifest")) {
                    String manifestDLO = existingMetadata.getMetaData().get("X-Object-Manifest");
                    String segmentContainer = manifestDLO.substring(1, manifestDLO.indexOf(47, 1));
                    String segmentPath = manifestDLO.substring(manifestDLO.indexOf(47, 1), manifestDLO.length());
                    existingSegments.put(segmentContainer, this.listObjects(region, segmentContainer, segmentPath));
                    break block9;
                }
                if (existingMetadata.getMetaData().containsKey("X-Static-Large-Object")) {
                    boolean isSLO = "true".equals(existingMetadata.getMetaData().get("X-Static-Large-Object").toLowerCase(Locale.ENGLISH));
                    if (!isSLO) break block9;
                    JsonParser parser = new JsonParser();
                    URIBuilder urlBuild = new URIBuilder(region.getStorageUrl(container, name));
                    urlBuild.setParameter("multipart-manifest", "get");
                    URI url = urlBuild.build();
                    HttpGet method = new HttpGet(url);
                    Response response = this.execute((HttpRequestBase)method);
                    if (response.getStatusCode() == 200) {
                        String manifest = response.getResponseBodyAsString();
                        JsonArray segments = parser.parse(manifest).getAsJsonArray();
                        for (JsonElement o : segments) {
                            JsonObject segment = o.getAsJsonObject();
                            String objectPath = segment.get("name").getAsString();
                            String segmentContainer = objectPath.substring(1, objectPath.indexOf(47, 1));
                            String segmentPath = objectPath.substring(objectPath.indexOf(47, 1) + 1, objectPath.length());
                            ArrayList<StorageObject> containerSegments = (ArrayList<StorageObject>)existingSegments.get(segmentContainer);
                            if (containerSegments == null) {
                                containerSegments = new ArrayList<StorageObject>();
                                existingSegments.put(segmentContainer, containerSegments);
                            }
                            StorageObject object = new StorageObject(segmentPath);
                            object.setSize(Long.valueOf(segment.get("bytes").getAsString()));
                            object.setMd5sum(segment.get("hash").getAsString());
                            object.setLastModified(segment.get("last_modified").getAsString());
                            object.setMimeType(segment.get("content_type").getAsString());
                            containerSegments.add(object);
                        }
                        break block9;
                    }
                    method.abort();
                    throw new GenericException(response);
                }
                return null;
            }
            catch (NotFoundException e) {
                return null;
            }
            catch (JsonParseException e) {
                throw new GenericException("JSON parsing failed reading static large object manifest", e);
            }
            catch (URISyntaxException e) {
                throw new GenericException("URI Building failed reading static large object manifest", e);
            }
        }
        return existingSegments;
    }

    public String storeObject(Region region, String container, InputStream data, String contentType, String name, Map<String, String> metadata) throws IOException {
        HttpPut method = new HttpPut(region.getStorageUrl(container, name));
        InputStreamEntity entity = new InputStreamEntity(data, -1L);
        entity.setChunked(true);
        entity.setContentType(contentType);
        method.setEntity((HttpEntity)entity);
        for (Map.Entry<String, String> key : this.renameObjectMetadata(metadata).entrySet()) {
            method.setHeader(key.getKey(), key.getValue());
        }
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 201) {
            return response.getResponseHeader("ETag").getValue();
        }
        throw new GenericException(response);
    }

    public String storeObject(Region region, String container, String name, HttpEntity entity, Map<String, String> metadata, String md5sum) throws IOException {
        HttpPut method = new HttpPut(region.getStorageUrl(container, name));
        method.setEntity(entity);
        if (md5sum != null) {
            method.setHeader("ETag", md5sum);
        }
        method.setHeader(entity.getContentType());
        for (Map.Entry<String, String> key : this.renameObjectMetadata(metadata).entrySet()) {
            method.setHeader(key.getKey(), key.getValue());
        }
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 201) {
            return response.getResponseHeader("ETag").getValue();
        }
        throw new GenericException(response);
    }

    public String storeObject(Region region, String container, String name, HttpEntity entity, Map<String, String> metadata, String md5sum, Long objectSize, Long segmentSize, Boolean dynamicLargeObject, String segmentContainer, String segmentFolder, Boolean leaveSegments) throws IOException, InterruptedException {
        String manifestEtag;
        boolean useLargeObject;
        long singleObjectSizeLimit = (long)(5.0 * Math.pow(1024.0, 3.0));
        long minSegmentSize = 0x100000L;
        long actualSegmentSize = segmentSize == null ? (long)(4.0 * Math.pow(1024.0, 3.0)) : Math.max(segmentSize, minSegmentSize);
        objectSize = objectSize == null ? -1L : objectSize;
        boolean bl = useLargeObject = segmentSize != null && objectSize > actualSegmentSize || objectSize > singleObjectSizeLimit || segmentSize != null && objectSize == -1L;
        if (!useLargeObject) {
            return this.storeObject(region, container, name, entity, metadata, md5sum);
        }
        leaveSegments = leaveSegments == null ? Boolean.FALSE : leaveSegments;
        dynamicLargeObject = dynamicLargeObject == null ? Boolean.FALSE : dynamicLargeObject;
        segmentFolder = segmentFolder == null ? ".file-segments" : segmentFolder;
        segmentContainer = segmentContainer == null ? container : segmentContainer;
        Map<String, List<StorageObject>> oldSegmentsToRemove = null;
        if (!leaveSegments.booleanValue()) {
            oldSegmentsToRemove = this.listObjectSegments(region, container, name);
        }
        int segmentNumber = 1;
        long timeStamp = System.currentTimeMillis() / 1000L;
        String segmentBase = String.format("%s/%d/%d", segmentFolder, timeStamp, objectSize);
        PipedInputStream contentInStream = new PipedInputStream(65536);
        final PipedOutputStream contentOutStream = new PipedOutputStream(contentInStream);
        SubInputStream segmentStream = new SubInputStream(contentInStream, actualSegmentSize, false);
        final HttpEntity e = entity;
        Callable<Boolean> writer = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                e.writeTo((OutputStream)contentOutStream);
                return Boolean.TRUE;
            }
        };
        ExecutorService writeExecutor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = writeExecutor.submit(writer);
        HashMap newSegmentsAdded = new HashMap();
        LinkedList<StorageObject> newSegments = new LinkedList<StorageObject>();
        JsonArray manifestSLO = new JsonArray();
        boolean finished = false;
        while (!finished) {
            String etag;
            String segmentName = String.format("%s/%08d", segmentBase, segmentNumber);
            try {
                etag = this.storeObject(region, segmentContainer, (InputStream)((Object)segmentStream), "application/octet-stream", segmentName, new HashMap<String, String>());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
            String segmentPath = segmentContainer + "/" + segmentName;
            long bytesUploaded = segmentStream.getBytesProduced();
            if (!dynamicLargeObject.booleanValue()) {
                JsonObject segmentJSON = new JsonObject();
                segmentJSON.addProperty("path", segmentPath);
                segmentJSON.addProperty("etag", etag);
                segmentJSON.addProperty("size_bytes", (Number)bytesUploaded);
                manifestSLO.add((JsonElement)segmentJSON);
                newSegments.add(new StorageObject(segmentName));
            }
            ++segmentNumber;
            if (!finished) {
                finished = segmentStream.endSourceReached();
            }
            newSegmentsAdded.put(segmentContainer, newSegments);
            segmentStream.readMoreBytes(actualSegmentSize);
        }
        try {
            future.get();
        }
        catch (InterruptedException segmentName) {
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw (RuntimeException)t;
        }
        if (dynamicLargeObject.booleanValue()) {
            long manifestTimeStamp = System.currentTimeMillis() / 1000L;
            metadata.put("X-Object-Meta-mtime", String.format("%s", manifestTimeStamp));
            manifestEtag = this.createDLOManifestObject(region, container, entity.getContentType().getValue(), name, segmentBase, metadata);
        } else {
            manifestEtag = this.createSLOManifestObject(region, container, entity.getContentType().getValue(), name, manifestSLO.toString(), metadata);
        }
        if (!leaveSegments.booleanValue() && oldSegmentsToRemove != null) {
            for (String c : oldSegmentsToRemove.keySet()) {
                List<StorageObject> rmv = oldSegmentsToRemove.get(c);
                if (newSegmentsAdded.containsKey(c)) {
                    rmv.removeAll((Collection)newSegmentsAdded.get(c));
                }
                LinkedList<String> rmvNames = new LinkedList<String>();
                for (StorageObject s : rmv) {
                    rmvNames.add(s.getName());
                }
                this.deleteObjects(region, c, rmvNames);
            }
        }
        return manifestEtag;
    }

    public String storeObject(Region region, String container, String name, HttpEntity entity, Map<String, String> metadata, String md5sum, Long objectSize) throws IOException, InterruptedException {
        return this.storeObject(region, container, name, entity, metadata, md5sum, objectSize, null, null, null, null, null);
    }

    private Map<String, String> renameContainerMetadata(Map<String, String> metadata) {
        return this.renameMetadata(metadata, "X-Container-Meta-");
    }

    private Map<String, String> renameObjectMetadata(Map<String, String> metadata) {
        return this.renameMetadata(metadata, "X-Object-Meta-");
    }

    private Map<String, String> renameMetadata(Map<String, String> metadata, String prefix) {
        HashMap<String, String> converted = new HashMap<String, String>(metadata.size());
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            if (entry.getKey().startsWith(prefix)) {
                converted.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!Constants.HTTP_HEADER_EDITABLE_NAMES.contains(entry.getKey().toLowerCase(Locale.ENGLISH))) {
                converted.put(prefix + entry.getKey(), Client.encode(entry.getValue()));
                continue;
            }
            converted.put(entry.getKey(), entry.getValue());
        }
        return converted;
    }

    private static String encode(String object) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(object).replaceAll("\\+", "%20");
        }
        catch (EncoderException ee) {
            return object;
        }
    }

    public String copyObject(Region region, String sourceContainer, String sourceObjName, String destContainer, String destObjName) throws IOException {
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("multipart-manifest", "get"));
        HttpPut method = new HttpPut(region.getStorageUrl(destContainer, destObjName, parameters));
        method.setHeader("X-Copy-From", Client.encode(sourceContainer) + "/" + Client.encode(sourceObjName));
        Response response = this.execute((HttpRequestBase)method, new DefaultResponseHandler());
        if (response.getStatusCode() == 201) {
            return response.getResponseHeader("ETag").getValue();
        }
        throw new GenericException(response);
    }

    public void deleteObject(Region region, String container, String object) throws IOException {
        HttpDelete method = new HttpDelete(region.getStorageUrl(container, object));
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public void deleteObjects(Region region, String container, List<String> objects) throws IOException {
        HttpEntityEnclosingRequestBase method = new HttpEntityEnclosingRequestBase(){

            public String getMethod() {
                return "DELETE";
            }
        };
        LinkedList<NameValuePair> parameters = new LinkedList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("bulk-delete", "1"));
        method.setURI(region.getStorageUrl(container, parameters));
        method.setHeader("Content-Type", "text/plain");
        StringBuilder body = new StringBuilder();
        for (String object : objects) {
            String path = region.getStorageUrl(container, object).getRawPath();
            body.append(path.substring(region.getStorageUrl().getRawPath().length() + 1)).append('\n');
        }
        method.setEntity((HttpEntity)new StringEntity(body.toString(), "UTF-8"));
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public ObjectMetadata getObjectMetaData(Region region, String container, String object) throws IOException {
        HttpHead method = new HttpHead(region.getStorageUrl(container, object));
        return this.execute((HttpRequestBase)method, new ObjectMetadataResponseHandler());
    }

    public ContainerMetadata getContainerMetaData(Region region, String container) throws IOException {
        HttpHead method = new HttpHead(region.getStorageUrl(container));
        return this.execute((HttpRequestBase)method, new ContainerMetadataResponseHandler());
    }

    public Response getObject(Region region, String container, String object) throws IOException {
        HttpGet method = new HttpGet(region.getStorageUrl(container, object));
        Response response = this.execute((HttpRequestBase)method);
        if (response.getStatusCode() == 200) {
            return response;
        }
        if (response.getStatusCode() == 404) {
            method.abort();
            throw new NotFoundException(response);
        }
        method.abort();
        throw new GenericException(response);
    }

    public Response getObject(Region region, String container, String object, long offset) throws IOException {
        return this.getObject(region, container, object, offset, -1L);
    }

    public Response getObject(Region region, String container, String object, long offset, long length) throws IOException {
        HttpGet method = new HttpGet(region.getStorageUrl(container, object));
        if (length > 0L) {
            method.setHeader("Range", String.format("bytes=%d-%d", offset, offset + length));
        } else {
            method.setHeader("Range", String.format("bytes=%d-", offset));
        }
        Response response = this.execute((HttpRequestBase)method);
        if (response.getStatusCode() == 206) {
            return response;
        }
        if (response.getStatusCode() == 404) {
            method.abort();
            throw new NotFoundException(response);
        }
        method.abort();
        throw new GenericException(response);
    }

    public void updateObjectManifest(Region region, String container, String object, String manifest) throws IOException {
        this.updateObjectMetadataAndManifest(region, container, object, new HashMap<String, String>(), manifest);
    }

    public void updateObjectMetadata(Region region, String container, String object, Map<String, String> metadata) throws IOException {
        this.updateObjectMetadataAndManifest(region, container, object, metadata, null);
    }

    public void updateObjectMetadataAndManifest(Region region, String container, String object, Map<String, String> metadata, String manifest) throws IOException {
        HttpPost method = new HttpPost(region.getStorageUrl(container, object));
        if (manifest != null) {
            method.setHeader("X-Object-Manifest", manifest);
        }
        for (Map.Entry<String, String> key : this.renameObjectMetadata(metadata).entrySet()) {
            method.setHeader(key.getKey(), key.getValue());
        }
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public void updateContainerMetadata(Region region, String container, Map<String, String> metadata) throws IOException {
        HttpPost method = new HttpPost(region.getStorageUrl(container));
        for (Map.Entry<String, String> key : this.renameContainerMetadata(metadata).entrySet()) {
            method.setHeader(key.getKey(), key.getValue());
        }
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public void updateAccountMetadata(Region region, Map<String, String> metadata) throws IOException {
        HttpPost method = new HttpPost(region.getStorageUrl());
        for (Map.Entry<String, String> key : metadata.entrySet()) {
            method.setHeader(key.getKey(), key.getValue());
        }
        this.execute((HttpRequestBase)method, new DefaultResponseHandler());
    }

    public static enum AuthVersion {
        v10,
        v11,
        v20,
        v3;

    }
}

