/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.AbstractAesCipherDetails;
import com.joyent.manta.client.crypto.AesCipherDetailsFactory;
import com.joyent.manta.client.crypto.ByteRangeConversion;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import javax.crypto.Cipher;
import org.apache.commons.lang3.Validate;

public final class AesCbcCipherDetails
extends AbstractAesCipherDetails {
    public static final SupportedCipherDetails INSTANCE_128_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.CBC, 128);
    public static final SupportedCipherDetails INSTANCE_192_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.CBC, 192);
    public static final SupportedCipherDetails INSTANCE_256_BIT = AesCipherDetailsFactory.buildWith(AesCipherDetailsFactory.CipherMode.CBC, 256);

    protected AesCbcCipherDetails(int keyLengthBits) {
        super(keyLengthBits, "AES/CBC/PKCS5Padding", "HmacMD5");
    }

    @Override
    public long ciphertextSize(long plaintextSize) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)plaintextSize);
        int blockBytes = this.getBlockSizeInBytes();
        int tagOrHmacBytes = this.getAuthenticationTagOrHmacLengthInBytes();
        byte[] iv = this.getCipher().getIV();
        boolean hasIV = iv != null && iv.length > 0;
        return AesCbcCipherDetails.calculateContentLength(plaintextSize, blockBytes, tagOrHmacBytes, hasIV);
    }

    @Override
    public long plaintextSize(long ciphertextSize) {
        Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)ciphertextSize);
        if (ciphertextSize == (long)(this.getBlockSizeInBytes() + this.getAuthenticationTagOrHmacLengthInBytes())) {
            return 0L;
        }
        return ciphertextSize - (long)this.getBlockSizeInBytes() - (long)this.getAuthenticationTagOrHmacLengthInBytes();
    }

    @Override
    public boolean plaintextSizeCalculationIsAnEstimate() {
        return true;
    }

    @Override
    public ByteRangeConversion translateByteRange(long startInclusive, long endInclusive) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public long updateCipherToPosition(Cipher cipher, long position) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean supportsRandomAccess() {
        return false;
    }

    static long calculateContentLength(long plaintextSize, int blockBytes, int tagOrHmacBytes, boolean hasIV) {
        if (plaintextSize <= 0L) {
            return (long)blockBytes + (long)tagOrHmacBytes;
        }
        long calculatedContentLength = plaintextSize;
        long padding = 0L;
        if (plaintextSize > (long)blockBytes) {
            padding = plaintextSize % (long)blockBytes;
        } else {
            calculatedContentLength = blockBytes;
        }
        if (padding > 0L) {
            calculatedContentLength = plaintextSize - padding + (long)blockBytes;
        }
        if (!hasIV && plaintextSize >= (long)blockBytes) {
            long blocks = Math.floorDiv(plaintextSize, (long)blockBytes);
            calculatedContentLength = (blocks + 1L) * (long)blockBytes;
        }
        return calculatedContentLength += (long)tagOrHmacBytes;
    }
}

