/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.EncryptingEntityHelper;
import com.joyent.manta.client.crypto.EncryptionContext;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.exception.MantaClientEncryptionException;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.http.MantaContentTypes;
import com.joyent.manta.http.entity.EmbeddedHttpContent;
import com.joyent.manta.util.HmacOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.bouncycastle.crypto.macs.HMac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptingEntity
implements HttpEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptingEntity.class);
    public static final long UNKNOWN_LENGTH = -1L;
    private static final Header CRYPTO_TRANSFER_ENCODING = null;
    private static final Header CRYPTO_CONTENT_TYPE = new BasicHeader("Content-Type", MantaContentTypes.ENCRYPTED_OBJECT.toString());
    private long originalLength;
    private EncryptionContext encryptionContext;
    private final HttpEntity wrapped;

    public EncryptingEntity(SecretKey key, SupportedCipherDetails cipherDetails, HttpEntity wrapped) {
        if (this.originalLength > cipherDetails.getMaximumPlaintextSizeInBytes()) {
            String msg = String.format("Input content length exceeded maximum [%d] number of bytes supported by cipher [%s]", cipherDetails.getMaximumPlaintextSizeInBytes(), cipherDetails.getCipherAlgorithm());
            throw new MantaClientEncryptionException(msg);
        }
        this.encryptionContext = new EncryptionContext(key, cipherDetails, false);
        this.originalLength = wrapped.getContentLength();
        this.wrapped = wrapped;
    }

    public boolean isRepeatable() {
        return this.wrapped.isRepeatable();
    }

    public boolean isChunked() {
        return this.originalLength < 0L;
    }

    public long getContentLength() {
        if (this.originalLength >= 0L) {
            return this.encryptionContext.getCipherDetails().ciphertextSize(this.originalLength);
        }
        return -1L;
    }

    public long getOriginalLength() {
        return this.originalLength;
    }

    public Header getContentType() {
        return CRYPTO_CONTENT_TYPE;
    }

    public Header getContentEncoding() {
        return CRYPTO_TRANSFER_ENCODING;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.wrapped.getContent();
    }

    public void writeTo(OutputStream httpOut) throws IOException {
        this.encryptionContext = new EncryptionContext(this.encryptionContext.getSecretKey(), this.encryptionContext.getCipherDetails(), this.encryptionContext.getCipher().getIV(), this.encryptionContext.requireCloneableCipher());
        OutputStream out = EncryptingEntityHelper.makeCipherOutputForStream(httpOut, this.encryptionContext);
        this.copyContentToOutputStream(out);
        out.close();
        if (out instanceof HmacOutputStream) {
            HMac hmac = ((HmacOutputStream)out).getHmac();
            int hmacSize = hmac.getMacSize();
            byte[] hmacBytes = new byte[hmacSize];
            hmac.doFinal(hmacBytes, 0);
            Validate.isTrue((hmacBytes.length == hmacSize ? 1 : 0) != 0, (String)"HMAC actual bytes doesn't equal the number of bytes expected", (Object[])new Object[0]);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("HMAC: {}", (Object)Hex.encodeHexString((byte[])hmacBytes));
            }
            httpOut.write(hmacBytes);
        }
    }

    private void copyContentToOutputStream(OutputStream out) throws IOException {
        long bytesCopied;
        if (this.wrapped.getClass().equals(EmbeddedHttpContent.class)) {
            CountingOutputStream cout = new CountingOutputStream(out);
            this.wrapped.writeTo((OutputStream)cout);
            cout.flush();
            bytesCopied = cout.getByteCount();
        } else {
            int bufferSize = 128;
            InputStream contentStream = this.getContent();
            bytesCopied = IOUtils.copy((InputStream)contentStream, (OutputStream)out, (int)128);
            out.flush();
            try {
                contentStream.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close content stream in EncryptingEntity.", (Throwable)e);
            }
        }
        if (this.originalLength == -1L) {
            this.originalLength = bytesCopied;
        } else if (this.originalLength != bytesCopied) {
            MantaIOException e = new MantaIOException("Bytes copied doesn't equal the specified content length");
            e.setContextValue("specifiedContentLength", this.originalLength);
            e.setContextValue("actualContentLength", bytesCopied);
            throw e;
        }
    }

    public boolean isStreaming() {
        return this.wrapped.isStreaming();
    }

    public void consumeContent() throws IOException {
        this.wrapped.consumeContent();
    }

    public Cipher getCipher() {
        return this.encryptionContext.getCipher();
    }
}

