/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class LRUCache<Key, Value> {
    private static final Logger log = Logger.getLogger(LRUCache.class);
    private final Cache<Key, Value> delegate;

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader) {
        return LRUCache.usingLoader(loader, null, -1L, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, RemovalListener<Key, Value> listener) {
        return LRUCache.usingLoader(loader, listener, -1L, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, long maximumSize) {
        return LRUCache.usingLoader(loader, null, maximumSize, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, RemovalListener<Key, Value> listener, long maximumSize) {
        return LRUCache.usingLoader(loader, listener, maximumSize, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, RemovalListener<Key, Value> listener, long maximumSize, long expireDuration) {
        return new LRUCache<Key, Value>(loader, listener, maximumSize, expireDuration);
    }

    public static <Key, Value> LRUCache<Key, Value> build() {
        return LRUCache.build(null, -1L, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> build(RemovalListener<Key, Value> listener) {
        return LRUCache.build(listener, -1L, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> build(long maximumSize) {
        return LRUCache.build(null, maximumSize, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> build(RemovalListener<Key, Value> listener, long maximumSize) {
        return LRUCache.build(listener, maximumSize, -1L);
    }

    public static <Key, Value> LRUCache<Key, Value> build(RemovalListener<Key, Value> listener, long maximumSize, long expireDuration) {
        return new LRUCache<Key, Value>(null, listener, maximumSize, expireDuration);
    }

    private LRUCache(final Function<Key, Value> loader, final RemovalListener<Key, Value> listener, long maximumSize, long expireDuration) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (listener != null) {
            builder.removalListener(new RemovalListener<Key, Value>(){

                public void onRemoval(RemovalNotification<Key, Value> notification) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Removed %s from cache with cause %s", notification.getKey(), notification.getCause()));
                    }
                    listener.onRemoval(notification);
                }
            });
        }
        if (maximumSize > 0L) {
            builder.maximumSize(maximumSize);
        }
        if (expireDuration > 0L) {
            builder.expireAfterAccess(expireDuration, TimeUnit.MILLISECONDS);
        }
        this.delegate = loader != null ? builder.build(new CacheLoader<Key, Value>(){

            public Value load(Key key) {
                return loader.apply(key);
            }
        }) : builder.build();
    }

    public Value get(Key key) throws UncheckedExecutionException {
        if (this.delegate instanceof LoadingCache) {
            return (Value)((LoadingCache)this.delegate).getUnchecked(key);
        }
        return (Value)this.delegate.getIfPresent(key);
    }

    public Map<Key, Value> asMap() {
        return Collections.unmodifiableMap(this.delegate.asMap());
    }

    public void put(Key key, Value value) {
        if (null == key || null == value) {
            log.warn((Object)String.format("Discard caching %s=%s", key, value));
            return;
        }
        this.delegate.put(key, value);
    }

    public void remove(Key key) {
        this.delegate.invalidate(key);
    }

    public long size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.size() == 0L;
    }

    public boolean contains(Key key) {
        return null != this.delegate.getIfPresent(key);
    }

    public void clear() {
        this.delegate.invalidateAll();
    }

    public void evict() {
        this.delegate.cleanUp();
    }
}

