/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cdn;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cdn.Distribution;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DistributionUrlProvider
implements UrlProvider {
    private final Distribution distribution;
    private final PathContainerService containerService = new PathContainerService();

    public DistributionUrlProvider(Distribution distribution) {
        this.distribution = distribution;
    }

    @Override
    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        list.add(new DescriptiveUrl(this.toUrl(file, this.distribution.getOrigin()), DescriptiveUrl.Type.origin, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), LocaleFactory.localizedString("Origin", "Info"))));
        if (this.distribution.getUrl() != null) {
            list.add(new DescriptiveUrl(this.toUrl(file, this.distribution.getUrl()), DescriptiveUrl.Type.cdn, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), LocaleFactory.localizedString(this.distribution.getMethod().toString(), "S3"))));
        }
        if (this.distribution.getSslUrl() != null) {
            list.add(new DescriptiveUrl(this.toUrl(file, this.distribution.getSslUrl()), DescriptiveUrl.Type.cdn, String.format("%s (SSL)", MessageFormat.format(LocaleFactory.localizedString("{0} URL"), LocaleFactory.localizedString(this.distribution.getMethod().toString(), "S3")))));
        }
        if (this.distribution.getStreamingUrl() != null) {
            list.add(new DescriptiveUrl(this.toUrl(file, this.distribution.getStreamingUrl()), DescriptiveUrl.Type.cdn, String.format("%s (Streaming)", MessageFormat.format(LocaleFactory.localizedString("{0} URL"), LocaleFactory.localizedString(this.distribution.getMethod().toString(), "S3")))));
        }
        if (this.distribution.getiOSstreamingUrl() != null) {
            list.add(new DescriptiveUrl(this.toUrl(file, this.distribution.getiOSstreamingUrl()), DescriptiveUrl.Type.cdn, String.format("%s (iOS Streaming)", MessageFormat.format(LocaleFactory.localizedString("{0} URL"), LocaleFactory.localizedString(this.distribution.getMethod().toString(), "S3")))));
        }
        list.addAll(this.toCnameUrl(file));
        return list;
    }

    private URI toUrl(Path file, URI origin) {
        StringBuilder b = new StringBuilder(String.format("%s://%s", origin.getScheme(), origin.getHost()));
        if (this.distribution.getMethod().equals(Distribution.CUSTOM)) {
            b.append('/').append(URIEncoder.encode(PathRelativizer.relativize(origin.getRawPath(), file.getAbsolute())));
        } else {
            if (StringUtils.isNotEmpty((CharSequence)origin.getRawPath())) {
                b.append(origin.getRawPath());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.containerService.getKey(file))) {
                b.append('/').append(URIEncoder.encode(this.containerService.getKey(file)));
            }
        }
        return URI.create(b.toString()).normalize();
    }

    private List<DescriptiveUrl> toCnameUrl(Path file) {
        ArrayList<DescriptiveUrl> urls = new ArrayList<DescriptiveUrl>();
        for (String cname : this.distribution.getCNAMEs()) {
            StringBuilder b = new StringBuilder();
            b.append(String.format("%s://%s", new Object[]{this.distribution.getMethod().getScheme(), cname})).append(this.distribution.getMethod().getContext());
            if (StringUtils.isNotEmpty((CharSequence)this.containerService.getKey(file))) {
                b.append('/').append(URIEncoder.encode(this.containerService.getKey(file)));
            }
            urls.add(new DescriptiveUrl(URI.create(b.toString()).normalize(), DescriptiveUrl.Type.cname, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), LocaleFactory.localizedString(this.distribution.getMethod().toString(), "S3"))));
        }
        return urls;
    }
}

