/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.irods.jargon.core.exception.NoResourceDefinedException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.io.FileIOOperations;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileOutputStream
extends OutputStream {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IRODSFile irodsFile;
    private final FileIOOperations fileIOOperations;
    private DataObjInp.OpenFlags openFlags = DataObjInp.OpenFlags.WRITE;

    protected FileIOOperations getFileIOOperations() {
        return this.fileIOOperations;
    }

    protected IRODSFileOutputStream(IRODSFile irodsFile, FileIOOperations fileIOOperations, DataObjInp.OpenFlags openFlags) throws NoResourceDefinedException, FileNotFoundException, JargonException {
        this.checkFileParameter(irodsFile);
        if (fileIOOperations == null) {
            throw new IllegalArgumentException("fileIOOperations is null");
        }
        if (openFlags == null) {
            throw new IllegalArgumentException("openFlags is null");
        }
        this.irodsFile = irodsFile;
        this.openFlags = openFlags;
        this.openIRODSFile(fileIOOperations);
        this.fileIOOperations = fileIOOperations;
    }

    private int openIRODSFile(FileIOOperations fileIOOperations) throws NoResourceDefinedException, JargonException {
        this.log.info("openIRODSFile()");
        int fileDescriptor = -1;
        boolean exists = this.irodsFile.exists();
        this.log.info("exists? {}", (Object)exists);
        this.irodsFile.setOpenFlags(this.openFlags);
        if (exists) {
            if (this.openFlags == DataObjInp.OpenFlags.WRITE_FAIL_IF_EXISTS || this.openFlags == DataObjInp.OpenFlags.READ_WRITE_FAIL_IF_EXISTS) {
                this.log.error("file exists, open flags indicate failure intended");
                throw new JargonException("Attempt to open a file that exists is an error based on the desired openFlags");
            }
            this.log.info("open file with given flags");
            this.irodsFile.open(this.openFlags);
        } else {
            this.log.info("file does not exist, create it");
            this.irodsFile.createNewFileCheckNoResourceFound(this.openFlags);
        }
        fileDescriptor = this.irodsFile.getFileDescriptor();
        if (this.openFlags == DataObjInp.OpenFlags.READ_WRITE || this.openFlags == DataObjInp.OpenFlags.READ_WRITE_CREATE_IF_NOT_EXISTS) {
            this.log.info("seeking to end of file based on open flags...");
            fileIOOperations.seek(fileDescriptor, 0L, FileIOOperations.SeekWhenceType.SEEK_END);
        }
        if (fileDescriptor == -1) {
            String msg = "no file descriptor returned from file creation";
            this.log.error(msg);
            throw new JargonException(msg);
        }
        return fileDescriptor;
    }

    private void checkFileParameter(IRODSFile file) throws JargonRuntimeException {
        if (file == null) {
            String msg = "file is null";
            this.log.error(msg);
            throw new JargonRuntimeException(msg);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.irodsFile.close();
            if (this.getFileIOOperations().getJargonProperties().isComputeAndVerifyChecksumAfterTransfer() || this.getFileIOOperations().getJargonProperties().isComputeChecksumAfterTransfer()) {
                this.log.info("computing checksum per jargon properties settings");
                this.getFileIOOperations().computeChecksumOnIrodsFile(this.irodsFile.getAbsolutePath());
            }
        }
        catch (JargonException e) {
            String msg = "JargonException caught in constructor, rethrow as IOException";
            this.log.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    private void checkIfOpen() throws IOException {
        if (this.irodsFile.getFileDescriptor() == -1) {
            this.log.debug("this file is not open, will throw an IOException");
            throw new IOException("operation attempted on unopened file:" + this.irodsFile.getAbsolutePath());
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null || b.length == 0) {
            this.log.warn("nothing to write, ignore");
            return;
        }
        this.checkIfOpen();
        try {
            this.fileIOOperations.write(this.getFileDescriptor(), b, off, len);
        }
        catch (JargonException e) {
            this.log.error("rethrowing JargonException as IO exception for write operation", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkIfOpen();
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfOpen();
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, buffer.length);
    }

    public int getFileDescriptor() {
        return this.irodsFile.getFileDescriptor();
    }
}

