/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CharacterRules;
import ch.cyberduck.core.sds.io.swagger.client.model.PasswordExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import ch.cyberduck.core.sds.io.swagger.client.model.UserLockout;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Login password policies")
public class LoginPasswordPolicies {
    @JsonProperty(value="characterRules")
    private CharacterRules characterRules = null;
    @JsonProperty(value="minLength")
    private Integer minLength = null;
    @JsonProperty(value="rejectDictionaryWords")
    private Boolean rejectDictionaryWords = null;
    @JsonProperty(value="rejectUserInfo")
    private Boolean rejectUserInfo = null;
    @JsonProperty(value="rejectKeyboardPatterns")
    private Boolean rejectKeyboardPatterns = null;
    @JsonProperty(value="numberOfArchivedPasswords")
    private Integer numberOfArchivedPasswords = null;
    @JsonProperty(value="passwordExpiration")
    private PasswordExpiration passwordExpiration = null;
    @JsonProperty(value="userLockout")
    private UserLockout userLockout = null;
    @JsonProperty(value="updatedAt")
    private DateTime updatedAt = null;
    @JsonProperty(value="updatedBy")
    private UserInfo updatedBy = null;

    public LoginPasswordPolicies characterRules(CharacterRules characterRules) {
        this.characterRules = characterRules;
        return this;
    }

    @Schema(required=true, description="")
    public CharacterRules getCharacterRules() {
        return this.characterRules;
    }

    public void setCharacterRules(CharacterRules characterRules) {
        this.characterRules = characterRules;
    }

    public LoginPasswordPolicies minLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    @Schema(required=true, description="Minimum number of characters a password must contain")
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public LoginPasswordPolicies rejectDictionaryWords(Boolean rejectDictionaryWords) {
        this.rejectDictionaryWords = rejectDictionaryWords;
        return this;
    }

    @Schema(required=true, description="Determines whether a password must NOT contain word(s) from a dictionary")
    public Boolean isRejectDictionaryWords() {
        return this.rejectDictionaryWords;
    }

    public void setRejectDictionaryWords(Boolean rejectDictionaryWords) {
        this.rejectDictionaryWords = rejectDictionaryWords;
    }

    public LoginPasswordPolicies rejectUserInfo(Boolean rejectUserInfo) {
        this.rejectUserInfo = rejectUserInfo;
        return this;
    }

    @Schema(required=true, description="Determines whether a password must NOT contain user info (first name, last name, email, user name)")
    public Boolean isRejectUserInfo() {
        return this.rejectUserInfo;
    }

    public void setRejectUserInfo(Boolean rejectUserInfo) {
        this.rejectUserInfo = rejectUserInfo;
    }

    public LoginPasswordPolicies rejectKeyboardPatterns(Boolean rejectKeyboardPatterns) {
        this.rejectKeyboardPatterns = rejectKeyboardPatterns;
        return this;
    }

    @Schema(required=true, description="Determines whether a password must NOT contain keyboard patterns (e.g. `qwertz`, `asdf`)  (min. 4 character pattern)")
    public Boolean isRejectKeyboardPatterns() {
        return this.rejectKeyboardPatterns;
    }

    public void setRejectKeyboardPatterns(Boolean rejectKeyboardPatterns) {
        this.rejectKeyboardPatterns = rejectKeyboardPatterns;
    }

    public LoginPasswordPolicies numberOfArchivedPasswords(Integer numberOfArchivedPasswords) {
        this.numberOfArchivedPasswords = numberOfArchivedPasswords;
        return this;
    }

    @Schema(required=true, description="Number of passwords to archive  (must be between `0` and `10`; `0` means that password history is disabled)")
    public Integer getNumberOfArchivedPasswords() {
        return this.numberOfArchivedPasswords;
    }

    public void setNumberOfArchivedPasswords(Integer numberOfArchivedPasswords) {
        this.numberOfArchivedPasswords = numberOfArchivedPasswords;
    }

    public LoginPasswordPolicies passwordExpiration(PasswordExpiration passwordExpiration) {
        this.passwordExpiration = passwordExpiration;
        return this;
    }

    @Schema(required=true, description="")
    public PasswordExpiration getPasswordExpiration() {
        return this.passwordExpiration;
    }

    public void setPasswordExpiration(PasswordExpiration passwordExpiration) {
        this.passwordExpiration = passwordExpiration;
    }

    public LoginPasswordPolicies userLockout(UserLockout userLockout) {
        this.userLockout = userLockout;
        return this;
    }

    @Schema(required=true, description="")
    public UserLockout getUserLockout() {
        return this.userLockout;
    }

    public void setUserLockout(UserLockout userLockout) {
        this.userLockout = userLockout;
    }

    public LoginPasswordPolicies updatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(required=true, description="Modification date")
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public LoginPasswordPolicies updatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(required=true, description="")
    public UserInfo getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(UserInfo updatedBy) {
        this.updatedBy = updatedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginPasswordPolicies loginPasswordPolicies = (LoginPasswordPolicies)o;
        return Objects.equals(this.characterRules, loginPasswordPolicies.characterRules) && Objects.equals(this.minLength, loginPasswordPolicies.minLength) && Objects.equals(this.rejectDictionaryWords, loginPasswordPolicies.rejectDictionaryWords) && Objects.equals(this.rejectUserInfo, loginPasswordPolicies.rejectUserInfo) && Objects.equals(this.rejectKeyboardPatterns, loginPasswordPolicies.rejectKeyboardPatterns) && Objects.equals(this.numberOfArchivedPasswords, loginPasswordPolicies.numberOfArchivedPasswords) && Objects.equals(this.passwordExpiration, loginPasswordPolicies.passwordExpiration) && Objects.equals(this.userLockout, loginPasswordPolicies.userLockout) && Objects.equals(this.updatedAt, loginPasswordPolicies.updatedAt) && Objects.equals(this.updatedBy, loginPasswordPolicies.updatedBy);
    }

    public int hashCode() {
        return Objects.hash(this.characterRules, this.minLength, this.rejectDictionaryWords, this.rejectUserInfo, this.rejectKeyboardPatterns, this.numberOfArchivedPasswords, this.passwordExpiration, this.userLockout, this.updatedAt, this.updatedBy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginPasswordPolicies {\n");
        sb.append("    characterRules: ").append(this.toIndentedString(this.characterRules)).append("\n");
        sb.append("    minLength: ").append(this.toIndentedString(this.minLength)).append("\n");
        sb.append("    rejectDictionaryWords: ").append(this.toIndentedString(this.rejectDictionaryWords)).append("\n");
        sb.append("    rejectUserInfo: ").append(this.toIndentedString(this.rejectUserInfo)).append("\n");
        sb.append("    rejectKeyboardPatterns: ").append(this.toIndentedString(this.rejectKeyboardPatterns)).append("\n");
        sb.append("    numberOfArchivedPasswords: ").append(this.toIndentedString(this.numberOfArchivedPasswords)).append("\n");
        sb.append("    passwordExpiration: ").append(this.toIndentedString(this.passwordExpiration)).append("\n");
        sb.append("    userLockout: ").append(this.toIndentedString(this.userLockout)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

