/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPSession;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;

public class FTPDirectoryFeature
implements Directory<Integer> {
    private final FTPSession session;

    public FTPDirectoryFeature(FTPSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            if (!((FTPClient)((Object)this.session.getClient())).makeDirectory(folder.getAbsolute())) {
                throw new FTPException(((FTPClient)((Object)this.session.getClient())).getReplyCode(), ((FTPClient)((Object)this.session.getClient())).getReplyString());
            }
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        return new Path(folder.getParent(), folder.getName(), folder.getType(), new DefaultAttributesFinderFeature((Session)this.session).find(folder));
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public FTPDirectoryFeature withWriter(Write writer) {
        return this;
    }
}

