/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum ImportFormat {
    HTML,
    MARKDOWN,
    PLAIN_TEXT,
    OTHER;


    static class Serializer
    extends UnionSerializer<ImportFormat> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ImportFormat value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case HTML: {
                    g.writeString("html");
                    break;
                }
                case MARKDOWN: {
                    g.writeString("markdown");
                    break;
                }
                case PLAIN_TEXT: {
                    g.writeString("plain_text");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ImportFormat deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            ImportFormat value = "html".equals(tag) ? HTML : ("markdown".equals(tag) ? MARKDOWN : ("plain_text".equals(tag) ? PLAIN_TEXT : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

