/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.notification;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.foundation.NSUserNotification;
import ch.cyberduck.binding.foundation.NSUserNotificationCenter;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.notification.NotificationFilterService;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.resources.IconCacheFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public class NotificationCenter
extends ProxyController
implements NotificationService,
NSUserNotificationCenter.Delegate {
    private static final Logger log = Logger.getLogger(NotificationCenter.class);
    private final NSUserNotificationCenter center = NSUserNotificationCenter.defaultUserNotificationCenter();
    private final Set<NotificationService.Listener> listeners = Collections.synchronizedSet(new HashSet());
    private final NotificationFilterService filter = NotificationFilterService.Factory.get();

    public NotificationService setup() {
        this.center.setDelegate(this.id());
        return this;
    }

    public void unregister() {
        if (this.center.respondsToSelector(Foundation.selector((String)"removeAllDeliveredNotifications"))) {
            this.center.removeAllDeliveredNotifications();
        }
        this.listeners.clear();
    }

    public void addListener(NotificationService.Listener listener) {
        this.listeners.add(listener);
    }

    public void notify(String group, String identifier, String title, String description) {
        if (this.filter.shouldSuppress()) {
            log.debug((Object)String.format("Suppressing notification for %s, %s, %s, %s", group, identifier, title, description));
            return;
        }
        NSUserNotification notification = NSUserNotification.notification();
        if (StringUtils.isNotBlank((CharSequence)identifier)) {
            if (notification.respondsToSelector(Foundation.selector((String)"setIdentifier:"))) {
                notification.setIdentifier(identifier);
            }
            if (StringUtils.isNotBlank((CharSequence)Path.getExtension((String)identifier))) {
                notification.setContentImage((NSImage)IconCacheFactory.get().documentIcon(Path.getExtension((String)identifier), Integer.valueOf(32)));
            }
        }
        notification.setTitle(LocaleFactory.localizedString((String)title, (String)"Status"));
        notification.setInformativeText(description);
        notification.setHasActionButton(false);
        this.center.scheduleNotification(notification);
    }

    public void notify(String group, String identifier, String title, String description, String action) {
        if (this.filter.shouldSuppress()) {
            log.debug((Object)String.format("Suppressing notification for %s, %s, %s, %s", group, identifier, title, description));
            return;
        }
        NSUserNotification notification = NSUserNotification.notification();
        if (StringUtils.isNotBlank((CharSequence)identifier)) {
            if (notification.respondsToSelector(Foundation.selector((String)"setIdentifier:"))) {
                notification.setIdentifier(identifier);
            }
            if (!Scheme.isURL((String)identifier) && StringUtils.isNotBlank((CharSequence)Path.getExtension((String)identifier))) {
                notification.setContentImage((NSImage)IconCacheFactory.get().documentIcon(Path.getExtension((String)identifier), Integer.valueOf(32)));
            }
        }
        notification.setTitle(LocaleFactory.localizedString((String)title, (String)"Status"));
        notification.setInformativeText(description);
        notification.setHasActionButton(true);
        notification.setActionButtonTitle(action);
        this.center.scheduleNotification(notification);
    }

    public void userNotificationCenter_didActivateNotification(NSUserNotificationCenter center, NSUserNotification notification) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Did close notification %s with type %s", notification, notification.activationType()));
        }
        for (NotificationService.Listener listener : this.listeners) {
            listener.callback(notification.identifier());
        }
    }

    public boolean userNotificationCenter_shouldPresentNotification(NSUserNotificationCenter center, NSUserNotification notification) {
        log.warn((Object)String.format("Discarded notification %s without presenting", notification));
        return false;
    }
}

