/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.sftp.SFTPSession;
import java.io.IOException;

public class SFTPSymlinkFeature
implements Symlink {
    private final SFTPSession session;

    public SFTPSymlinkFeature(SFTPSession session) {
        this.session = session;
    }

    public void symlink(Path file, String target) throws BackgroundException {
        try {
            this.session.sftp().symlink(target, file.getAbsolute());
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map("Cannot create {0}", e, file);
        }
    }
}

